from sandbox import sdk2

from sandbox.common.types import task as ctt


class PublishNewsArchiveV2Wrapper(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        solomon_tvm_vault_selector = sdk2.parameters.YavSecret("Solomon TVM token from YAV", required=True)
        shard_map_torrent = sdk2.parameters.String("Shardmap rbtorrent. Use it if you want just publish this shardmap and don't want to get shards from YT", default_value=None)
        shards_count = sdk2.parameters.Integer("Shards count", required=True, default_value=112)
        newsd_shard_mapping_table = sdk2.parameters.String("slave_newsd shards mapping table", required=True, default_value="//home/news-prod/archive/newsd/shards")
        min_year = sdk2.parameters.Integer("Min year to store in archives", default_value=2010)
        fresh_days_gap = sdk2.parameters.Integer("Number of new days to skip", default_value=3)
        restore_shards = sdk2.parameters.Bool("Restore all shards", default_value=False)
        newsd_table = sdk2.parameters.String("Path to newsd table on YT", required=True, default_value="//home/news-prod/archive/newsd/newsd")
        newsd_statework_binary = sdk2.parameters.Resource("Resource with newsd_statework", required=True)
        ttl = sdk2.parameters.Integer("TTL of shard resource", required=True, default_value=14)
        shard_name_prefix = sdk2.parameters.String("Prefix for shard names", required=True, default_value="shardmap_arcnews_yp")
        autorelease_to = sdk2.parameters.String("Automaticaly release itself to", required=False, default="testing")

    class Context(sdk2.Context):
        child_task = None

    def on_execute(self):
        if self.Context.child_task is None:
            params = {
                "solomon_tvm_vault_selector": self.Parameters.solomon_tvm_vault_selector,
                "shard_map_torrent": self.Parameters.shard_map_torrent,
                "shards_count": self.Parameters.shards_count,
                "newsd_shard_mapping_table": self.Parameters.newsd_shard_mapping_table,
                "min_year": self.Parameters.min_year,
                "fresh_days_gap": self.Parameters.fresh_days_gap,
                "restore_shards": self.Parameters.restore_shards,
                "newsd_table": self.Parameters.newsd_table,
                "newsd_statework_binary": self.Parameters.newsd_statework_binary,
                "ttl": self.Parameters.ttl,
                "shard_name_prefix": self.Parameters.shard_name_prefix,
            }
            task = sdk2.Task['PUBLISH_NEWS_ARCHIVE_V_2'](self, **params)
            task.enqeue()
            self.Context.child_task = task.id
            self.Context.save()
            self.set_info("Begin waiting for task {}".format(self.Context.child_task))
            raise sdk2.WaitTask(task, ctt.Status.Group.FINISH + ctt.Status.Group.BREAK, wait_all=True)
        else:
            if self.Parameters.autorelease_to:
                self.set_info("Autorelease to {}".format(self.Parameters.autorelease_to))
                self.server.release(
                    params={
                        'task_id': self.Context.child_task,
                        'message': 'automatic selfrelease from PUBLISH_NEWS_ARCHIVE_V_2_WRAPPER',
                        'type': self.Parameters.autorelease_to,
                        'params': {},
                        'subject': 'automatic selfrelease from PUBLISH_NEWS_ARCHIVE_V_2_WRAPPER',
                    }
                )
            self.set_info("Complete")
