# -*- coding: utf-8 -*-

import os

from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.projects.common import apihelpers


class RunNewsStorageTrimmer(SandboxTask):
    """
        Run news storage trimmer
    """

    type = 'RUN_NEWS_STORAGE_TRIMMER'

    def on_execute(self):
        token = self.get_vault_data('NEWS', 'yt-storage-token')
        with open('temp-token', 'w') as fout:
            fout.write(token)
        trimmer = self.sync_resource(apihelpers.get_last_resource_with_attrs('NEWS_STORAGE_TRIMMER_EXECUTABLE', {'released': 'stable'}))
        config = self.sync_resource(apihelpers.get_last_resource_with_attrs('NEWS_STORAGE_TRIMMER_CONFIG', {'released': 'stable'}))
        run_process('{} {}'.format(trimmer, config), shell=True, log_prefix='run_trimmer', work_dir=os.getcwd())


__Task__ = RunNewsStorageTrimmer
