# -*- coding: utf-8 -*-

"""
This script serves to call
arcadia/yweb/news/scripts/yt_monitoring/sources_mon/montask.py,
with options passed through scripts/sandbox-options.txt
"""

import sandbox.projects.common.news.YtScriptTask as ys

from sandbox.sandboxsdk import parameters as sp
from sandbox.sandboxsdk import process


class MonMode(sp.SandboxIntegerParameter):
    name = "MonMode"
    description = "Mode of monitoring"
    required = True
    default_value = 0


class SourceMonitor(ys.YtScript):
    '''
    News source hourly monitoring
    '''

    type = "SOURCE_MONITOR"

    execution_space = 40 * 1024

    input_parameters = ys.get_base_params() + [MonMode]

    def on_execute(self):
        scriptdir = self.get_scripts()
        python_binary = self.get_python()

        token = self.get_token()

        ouf = open(scriptdir + "/sandbox-options.txt", "w")
        ouf.write(str(token) + "\n")
        ouf.write(str(self.ctx[MonMode.name]) + "\n")
        ouf.close()

        cmdline = "{python} {cmd}".format(
            python=python_binary,
            cmd=self.get_cmdline(),
        )

        process.run_process(cmdline, shell=True, work_dir=scriptdir, log_prefix='MONITOR')
