# -*- coding: utf-8 -*-

import urllib2
import json
import time

from datetime import date

from sandbox.sandboxsdk import parameters
import sandbox.common.errors as ce

from sandbox import sdk2

from sandbox.projects.news.resources import NEWS_CRON_VERIFY_ARCHIVES_CONFIG
from sandbox.projects.NewsAutoreleasableTask import NewsAutoreleasableTask
from sandbox.projects.NewsAutoreleasableTask import Params as NewsAutoreleasableTaskParams
from sandbox.projects.common.apihelpers import get_last_resource_with_attrs


class Params(object):
    class ApiUrl(parameters.SandboxStringParameter):
        name = 'api_url'
        description = 'news export api url'
        default_value = 'https://news.yandex.ru/api/v2/tops_export?client=news_cron&doclang=ru&issue=ru&stories_count=5'

    params = [ApiUrl]


class UpdateNewsCronVerifyArchivesConfig(NewsAutoreleasableTask):
    """"""

    type = "UPDATE_NEWS_CRON_VERIFY_ARCHIVES_CONFIG"

    input_parameters = NewsAutoreleasableTaskParams.params + Params.params

    def do_execute(self):

        api_response = json.loads(urllib2.urlopen(urllib2.Request(self.ctx.get(Params.ApiUrl.name))).read())

        archives_config_res = get_last_resource_with_attrs(
            resource_type=NEWS_CRON_VERIFY_ARCHIVES_CONFIG,
            attrs={'released': 'stable'}
        )

        if archives_config_res:
            old_file = self.sync_resource(archives_config_res)
            with open(old_file, "r") as r:
                archives_config = json.loads(r.read())

        today = date.today().strftime("%d.%m.%Y")
        for tab in api_response:
            if tab["alias"] == "index":
                if today not in archives_config:
                    archives_config[today] = []
                for i in range(0, 5):
                    archives_config[today].append(tab["stories"][i]["url"].split("?")[0] + "?t=" + str(tab["iter_time"]))

        if today not in archives_config:
            raise ce.TaskError("Strange api response? index rubric not found.")

        with open('archives_config.json', "w") as w:
            w.write(json.dumps(archives_config))

        resource = self.create_resource(
            description=self.descr,
            resource_path='archives_config.json',
            resource_type=NEWS_CRON_VERIFY_ARCHIVES_CONFIG,
            arch=self.arch,
            attributes={},
        )
        self.mark_resource_ready(resource.id)

        return True


__Task__ = UpdateNewsCronVerifyArchivesConfig
