# -*- coding: utf-8 -*-

import logging
from sandbox import sdk2
import sandbox.common.types.task as ctt
from sandbox.projects.rthub.UpdateRTHubResources import UpdateRTHubResources
from sandbox.projects.news.DownloadAdvWidgetClientsTable import DownloadAdvWidgetClientsTable
import fileinput
import re
from sandbox.sandboxsdk.errors import SandboxTaskFailureError


class UpdateRTHubAdvWidgetResources(UpdateRTHubResources):
    """
        Update dynamic resources for AdvWidget pakage
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 60000  # Mb

    class Parameters(sdk2.Task.Parameters):
        resource_name = 'ADV_WIDGET_CLIENTS_FILE'
        packages_list = 'advertising-widget'
        release_machine_component = None  # TODO add release machine 'advertising_widget'
        description = "Update dynamic resources for AdvWidget pakage"

        author = sdk2.parameters.String('Author of commit', default='zomb-sandbox-rw', required=True)
        release_resources = sdk2.parameters.Bool("Release created resources", default=False)
        release_resources_to = sdk2.parameters.String("Release created resources to (stable;prestable ,ect). ';'-separated", default="")

    def update_resources(self, resource_name):
        logging.info("Launching DownloadAdvWidgetClientsTable sub-task...")
        sub_task = DownloadAdvWidgetClientsTable(
            self,
            description="Updating AdvWidget RTHub resources (by {})".format(self.id),
            owner=self.Parameters.owner,
            priority=self.Parameters.priority,
            released_attr=self.Parameters.release_resources_to
        ).enqueue()
        self.Context.sub_task_id = sub_task.id
        raise sdk2.WaitTask([sub_task], ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True)

    def get_resource_ids(self):
        sub_task = self.find(id=self.Context.sub_task_id).first()
        new_res_list = ''
        if sub_task.status in ctt.Status.Group.SUCCEED and sub_task.Context.downloaded_resources:
            new_res_list = sub_task.Context.downloaded_resources
        return new_res_list

    def update_res_ids(self, file_path, new_res_name, new_res_id):
        for line in fileinput.FileInput(file_path, inplace=True):
            line = re.sub(
                '^FROM_SANDBOX\(FILE [0-9]+ OUT_NOAUTO {}\.json'.format(new_res_name),
                'FROM_SANDBOX(FILE {} OUT_NOAUTO {}.json'.format(new_res_id, new_res_name),
                line.rstrip()
            )
            print line

    def run_tests(self):
        sub_task = sdk2.Task["YA_MAKE"](
            self,
            owner=self.Parameters.owner,
            description='Run tests advertising_widget/filter_test',
            targets=';'.join(["robot/rthub/yql/udfs/advertising_widget/filter_test"]),
            test=True,
            build_type='release',
            check_return_code=True,
        ).enqueue()
        self.Context.test_task_id = sub_task.id
        raise sdk2.WaitTask(sub_task, ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True)

    def on_execute(self):
        with self.memoize_stage.first_step:
            self.update_resources(self.Parameters.resource_name)
        with self.memoize_stage.second_step:
            new_res_list = self.get_resource_ids()
            if len(new_res_list):
                self.commit_new_versions(new_res_list, 'advertising-widget/dynamic')
                self.run_tests()
        with self.memoize_stage.third_step:
            if len(self.get_resource_ids()):
                if sdk2.Task[self.Context.test_task_id].status != ctt.Status.SUCCESS:
                    raise SandboxTaskFailureError("Tests failed. Will not release resource.")
                self.release_tasks()
