# -*- coding: utf-8 -*-
from sandbox.sdk2.resource import Resource


backoffice_releasers = [
    'stupidhobbit',
    'melkonst',
    'npetric',
    'swarmer',
    'sgrb',
    'asp437',
    'dm-fish',
    'zvr-s',
    'x-mass',
    'ilnurbaykov',
]


class BACKOFFICE_EXECUTABLE(Resource):
    ttl = 'inf'
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = backoffice_releasers


class API_V1_EXECUTABLE(BACKOFFICE_EXECUTABLE):
    arcadia_build_path = 'yweb/news/news_back/api/admin/bin/'


class API_V2_EXECUTABLE(BACKOFFICE_EXECUTABLE):
    arcadia_build_path = 'yweb/news/news_back/api/v2/bin/'


class PARTNER_API_EXECUTABLE(BACKOFFICE_EXECUTABLE):
    arcadia_build_path = 'yweb/news/news_back/api/partner_api/bin/'


class PARTNER_API_V2_EXECUTABLE(BACKOFFICE_EXECUTABLE):
    arcadia_build_path = 'yweb/news/news_back/api/partner_api_v2/bin/'


class API_V3_EXECUTABLE(BACKOFFICE_EXECUTABLE):
    arcadia_build_path = 'yweb/news/news_back/api/v3/bin/'


class CELERY_EXECUTABLE(BACKOFFICE_EXECUTABLE):
    arcadia_build_path = 'yweb/news/news_back/api/celery/worker/'


class BACKOFFICE_NGINX_CONFIG(Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = backoffice_releasers
    arcadia_build_path = 'yweb/news/news_back/api/admin'


class BACKOFFICE_FRONT_BUILD(Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = backoffice_releasers
    arcadia_build_path = 'yweb/news/news_back/ui'
