# coding: utf-8
from sandbox import sdk2

RELEASERS = [
    'sgrb',
    'yurifrolov',
    'k-vukolov',
    'errorf',
    'ilya-gusev',
    'lyubanenko',
    'mmatrosova',
    'swarmer',
    'asp437',
    'vtyulb',
    'robot-ynews',
    'ismd',
    'robot-srch-releaser',
    'robot-testenv',
    'pokachopotun',
    'cosyx',
    'stupidhobbit',
    'melkonst',
    'npetric',
    'baymer',
    'robot-ynews-mon',
    'slavavikharev',
    'yurikiselev',
    'dm-fish',
    'nikshel',
    'tsarn',
    'vlaklimov',
    'dm-fish',
    'gsat83',
    'ilnurbaykov',
    'x-mass',
    'mpereskokova',
    'rekby',
    'maliugina',
    'svasilich',
    'zvr-s',
    'pagein',
    'leha322',
    'code-z',
    'dim-ch',
    'fedorov-cpp',
]


class PORTO_LAYER_SPORT_API(sdk2.Resource):
    """
        Porto слой для api Спорта.
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS


class PORTO_LAYER_SPORT_ADMIN(sdk2.Resource):
    """
        Porto слой для админки Спорта.
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS


class PORTO_LAYER_SPORT_IMPORTERS(sdk2.Resource):
    """
        Porto слой для celery-воркеров для импорта/экспорта спортивных данных.
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS


class NEWS_TKVA_EVLOGDUMP_EXECUTABLE(sdk2.Resource):
    """
        Tkva evlogdump executable
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS


class NEWS_DEFAULT_INDEX_CONFIG(sdk2.Resource):
    """
        default index config for slave_newsd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS + ['irrra']


class NEWS_RECOMMENDER_SYSTEM_CONFIG(sdk2.Resource):
    """
        config for personalization in slave_newsd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS + ['irrra']


class NEWS_SLAVE_NEWSD_DATA_CONF(sdk2.Resource):
    """
        data config for slave_newsd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS + ['irrra']


class NEWS_RECOMMENDER_MODEL(sdk2.Resource):
    """
        models for personalization
    """
    __default_attribute__ = sdk2.parameters.String

    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS + ['akulov', 'luorlova']


class NEWS_RANKING_MODEL(sdk2.Resource):
    """
        models for ranking
    """
    __default_attribute__ = sdk2.parameters.String

    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_RECOMMENDER_MODELS_PACKAGE(sdk2.Resource):
    """
        all models for recommender
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_RANKING_MODELS_PACKAGE(sdk2.Resource):
    """
        all models for ranking
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class ROUTERD_ALLOWED_ORIGINS(sdk2.Resource):
    """
        routerd allowed origins
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_THEMES_COMPONENTS(sdk2.Resource):
    """
        Components from themes-viewer
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_THEMES_COMPONENTS_ARCHIVE(sdk2.Resource):
    """
        Components from themes-viewer for archives
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_THEMES_TAGS_TO_COMPONENTS(sdk2.Resource):
    """
        Tag-to-component mapping from themes-viewer
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    signature = sdk2.parameters.String("signature")
    releasers = RELEASERS


class NEWS_THEMES_CLASSIFIER(sdk2.Resource):
    """
        Themes classifier and additional config
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_ARRANGED_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for arranged
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_ARRANGED_DATA_SERVER_CONF(sdk2.Resource):
    """
        config for state server in arranged
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_ARRANGED_DATA_CONF(sdk2.Resource):
    """
        config for data resources in arranged
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_ARRANGED_EXECUTABLE(sdk2.Resource):
    """
        News.Arranged daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS + ['lyubanenko']


class NEWS_APPHOST_ARRANGED_DEFAULT_FLAGS(sdk2.Resource):
    """
        config for default flags in arranged
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class ARRANGED_APPHOST_REQUESTS(sdk2.Resource):
    """
        arranged apphost request contexts
    """
    executable = False
    releasable = False
    auto_backup = True
    any_arch = True


class ARRANGED_APPHOST_RESPONSES(sdk2.Resource):
    """
        arranged apphost responses
    """
    __default_attribute__ = sdk2.parameters.String

    executable = False
    releasable = False
    auto_backup = True
    any_arch = True


class ARRANGED_RESPONSES_COMPARE_RESULT(sdk2.Resource):
    """
        result of comparing two ARRANGED_APPHOST_RESPONSES
    """
    executable = False
    releasable = False
    auto_backup = True
    any_arch = True


class NEWS_REGEXP_BINARY(sdk2.Resource):
    """
        Copyright regexp miner binary
    """
    executable = True
    releasable = True
    any_arch = True


class NEWS_REGEXP_PATCHES(sdk2.Resource):
    """
        Json of found regular expression patches
    """
    executable = False
    releasable = True
    any_arch = True


class NEWS_APPHOST_AUTHD_EXECUTABLE(sdk2.Resource):
    """
        News.Authd daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_AUTHD_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for authd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_SPORT_SETUP_EXECUTABLE(sdk2.Resource):
    """
        News.SportSetup daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_SPORT_SETUP_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for authd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_SPORT_BLENDER_EXECUTABLE(sdk2.Resource):
    """
        News.SportBlender daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_SPORT_BLENDER_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for authd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_SHE_SETUP_EXECUTABLE(sdk2.Resource):
    """
        News.SheSetup daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_SHE_SETUP_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for SheSetup
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_SHE_BLENDER_EXECUTABLE(sdk2.Resource):
    """
        News.SheBlender daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_SHE_BLENDER_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for SheBlender
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_SPORT_ENTITY_ID_MAP(sdk2.Resource):
    """
        sport_entity_id.json
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_AAB_COOKIE(sdk2.Resource):
    """
        news_aab_cookie.txt
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_QUOTES_SCRIPT(sdk2.Resource):
    """
        quotes.pl perl script
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_STATIC_DATA_PARAMS(sdk2.Resource):
    """
        news_static_data.json
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_ROUTERD_PARAMS_PRESETS(sdk2.Resource):
    """
        params_presets.json
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_QUOTES_RATES_VARS_SCRIPT(sdk2.Resource):
    """
        quotes-rates-variables.pl perl script
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_APPHOST_NEWS_STATIC_DATA_EXECUTABLE(sdk2.Resource):
    """
        News.NewsStaticData daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_NEWS_STATIC_DATA_EVLOGDUMP_EXECUTABLE(sdk2.Resource):
    """
        evlogdump reader for News.NewsStaticData daemon
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_YDBD_EXECUTABLE(sdk2.Resource):
    """
        News.Ydbd daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_NEWS_DATA_AAS_EXECUTABLE(sdk2.Resource):
    """
        News.NewsDataAAS daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_NEWS_STATIC_DATA_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for authd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_NEWS_DATA_AAS_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for authd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_SPORT_NEWS_DATA_CONF(sdk2.Resource):
    """
        sport_news_data.json config
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_SHE_NEWS_DATA_CONF(sdk2.Resource):
    """
        she_news_data.json config
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_SHE_SETUP_CONF(sdk2.Resource):
    """
        she_news_data.json config
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_SHE_TURBO_DOCS(sdk2.Resource):
    """
        she document urls which are availiable in turbo
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_APPHOST_API_RESPONDER(sdk2.Resource):
    """
        News.NewsApiResponder daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class YSON_LIST_FRAGMENT(sdk2.resource.AbstractResource):
    """
        yson list_fragment
    """
    executable = False
    releasable = False
    any_arch = True


class NEWS_RAW_NEWS_DOC_DUMP(YSON_LIST_FRAGMENT):
    """
        yson collection of serialized TRawNewsDoc
    """


class NEWS_NEWS_DOC_INFO_DUMP(YSON_LIST_FRAGMENT):
    """
        yson collection of serialized TNewsInfo
    """


class NEWS_TALK_DATA(sdk2.Resource):
    """
        result of GET_NEWS_TALK_DATA
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_DISTRICT_DATA(sdk2.Resource):
    """
        result of get_district_data.py
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class PUBLISHER_FOR_WIZARD_PACKAGE(sdk2.Resource):
    """
        publisher of data for wizard packed with config
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_SPORT_SETUP_CONF(sdk2.Resource):
    """
        sport_news_data.json config
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class DYNTABLE_PQ_COPIER_EXECUTABLE(sdk2.Resource):
    """
        Copier from yt dyntable to PQ
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class DYNTABLE_PQ_COPIER_CONFIG(sdk2.Resource):
    """
        Configuration file for the DYNTABLE_PQ_COPIER_EXECUTABLE
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class DYNTABLE_PQ_COPIER_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for DYNTABLE_PQ_COPIER
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_DUPSD_METRICS_PQ_DYNTABLE_COPIER_EXECUTABLE(sdk2.Resource):
    """
        Dupsd copier from PQ to dyntable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_CETONIA_TOPS_PQ_DYNTABLE_COPIER_EXECUTABLE(sdk2.Resource):
    """
        Cetonia tops copier from PQ to dyntable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_CETONIA_ITERATION_PQ_DYNTABLE_COPIER_EXECUTABLE(sdk2.Resource):
    """
        Cetonia iteration copier from PQ to yt installation
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_CETONIA_ITERATION_PQ_DYNTABLE_COPIER_CONFIG(sdk2.Resource):
    """
        configuration file for cetonia iteration copier from PQ to yt installation
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_CHRYSINA_YDB_PUSHER_EXECUTABLE(sdk2.Resource):
    """
        Chrysina from driver to YDB pusher
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_OFF_STATEMENT_RUNTIME_EXPORTER_EXECUTABLE(sdk2.Resource):
    """
        Official statement exporter: reads document stream, extracts official statements and exports them to runtime via an http handle
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_DUPSD_METRICS_PQ_DYNTABLE_COPIER_CONFIG(sdk2.Resource):
    """
        Config for the dupsd copier from PQ to dyntable
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_APPHOST_NEWS_PROXY_EXECUTABLE(sdk2.Resource):
    """
        NEWS_PROXY daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_NEWS_PROXY_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for NEWS_PROXY
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_NEW_RUNTIME_EXECUTABLE(sdk2.Resource):
    """
        NEW_RUNTIME daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_NEW_RUNTIME_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for NEW_RUNTIME
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_FRESH_TURBO_CHECKER_EXECUTABLE(sdk2.Resource):
    """
        fresh_turbo_checker executable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_FRESH_TURBO_CHECKER_CONFIG(sdk2.Resource):
    """
        fresh_turbo_checker_config.json
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_FRESH_TURBO_DOCUMENTS_JSON(sdk2.Resource):
    """
        fresh_turbo_documents.json
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_FRESH_TURBO_DOCUMENTS_PROTOBUF(sdk2.Resource):
    """
        fresh_turbo_documents.pb
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_EMERGENCY_BUILDER_SCRIPT(sdk2.Resource):
    """
        script for emergency builder yweb/news/runtime_scripts/emergency_builder/emergency_builder.sh
    """
    executable = False
    releasable = False
    auto_backup = True
    any_arch = True


class SPORT_VIDEO_COLLECTIONS(sdk2.Resource):
    """
        Sport api video collections
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class SPORT_VIDEO_CAROUSELS(sdk2.Resource):
    """
        vh sport video carousels
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_IMAGES_EXTRACTOR(sdk2.Resource):
    '''
        images_extractor binary
    '''
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    arcadia_build_path = 'yweb/news/media/extractor/images-extractor'
    releasers = RELEASERS


class NEWS_IMAGES_EXTRACTOR_DATA(sdk2.Resource):
    '''
        images_extractor data
    '''
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_TOP_AGENCIES(sdk2.Resource):
    '''
        json file with top agencies and its feeds
    '''
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_DUPSD_AGENCIES_JSON(sdk2.Resource):
    '''
        json file of agencies for dupsd
    '''
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_HUAWEI_API_REQUESTS(sdk2.Resource):
    """
        requests for huawei api
    """
    executable = False
    releasable = False
    auto_backup = True
    any_arch = False


class NEWS_HUAWEI_API_RESPONSES(sdk2.Resource):
    """
        responses for huawei api
    """
    executable = False
    releasable = False
    auto_backup = True
    any_arch = False


class NEWS_UATRAITS_PROFILES_XML(sdk2.Resource):
    """
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_UATRAITS_EXTRA_XML(sdk2.Resource):
    """
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_DUPSD_METRICS_VIEWER_PACKAGE(sdk2.Resource):
    """
        dups viewer package
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False


class NEWS_DYNAMIC_MODELS_ARCHIVE(sdk2.Resource):
    """
        Archive with news models for middlesearch
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = RELEASERS


class NEWS_REMOTE_LOGGER_EXECUTABLE(sdk2.Resource):
    """
        News remote logger daemon
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_VH_SELFSERVICE_EXECUTABLE(sdk2.Resource):
    """
        News vh selfservice processor
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_VH_UGC_SENDER_EXECUTABLE(sdk2.Resource):
    """
        News video hosting UGC sender
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_VH_CALLBACKS_EXECUTABLE(sdk2.Resource):
    """
        News video hosting callbacks handler
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_CRON_VERIFY_ARCHIVES_CONFIG(sdk2.Resource):
    """
        Archive with news models for middlesearch
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = RELEASERS


class NEWS_ADDITIONAL_RUBRICS_CONF(sdk2.Resource):
    """
        additional_rubrics.json
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_APPHOST_SERVICE_REQUESTS(sdk2.Resource):
    """
        apphost_service.requests
    """
    executable = False
    releasable = False
    auto_backup = True
    service_name = sdk2.Attributes.String("Name of the target service")
    any_arch = True


class NEWS_APPHOST_SERVICE_RESPONSES(sdk2.Resource):
    """
        apphost_service.requests
    """
    executable = False
    releasable = False
    auto_backup = True
    service_name = sdk2.Attributes.String("Name of the target service")
    any_arch = True


class NEWS_SLAVE_NEWSD_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for slave_newsd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_ARRANGED_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for arranged
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_YDBD_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for ydbd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_NEWS_STATIC_DATA_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for news_static_data
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_NEWS_DATA_AAS_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for news_data_aas
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_REARRANGED_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for rearranged
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_AUTHD_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for authd
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_NEWS_PROXY_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for news_proxy
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_NEW_RUNTIME_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for new_runtime
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_SPORT_BLENDER_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for sport_blender
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_APPHOST_API_RESPONDER_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for api_responder
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_API_RESPONDER_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for api_responder
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_ROUTERD_PERSISTENT_FLAGS(sdk2.resource.AbstractResource):
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_RT_VH_VISITS(sdk2.resource.AbstractResource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_PROTO_REARRANGED_EXECUTABLE(sdk2.Resource):
    """
        News.ProtoRearranged daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_PROTO_REARRANGED_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for proto_rearranged
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_PROTO_REARRANGED_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for proto_rearranged
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_EXPIRED_FLAGS_STAT(sdk2.Resource):
    """
        statistics about its flags
    """
    executable = False
    releasable = False
    auto_backup = True
    any_arch = True


class NEWS_RUNTIME_BANS(sdk2.Resource):
    """
        bans from its (for slave)
    """
    executable = False
    releasable = False
    auto_backup = True
    any_arch = False


class NEWS_MERGED_PROD_FLAGS(sdk2.Resource):
    """
        snapshot of production set of routerd flags
    """
    executable = False
    releasable = False
    auto_backup = True
    any_arch = False


class NEWS_ITS_PARAMS_PRESETS(sdk2.Resource):
    """
        snapshot of routerd its params presets
    """
    executable = False
    releasable = False
    auto_backup = True
    any_arch = False


class NEWS_FAKE_NOW_FILE(sdk2.Resource):
    """
        fake now for tests
    """
    executable = False
    releasable = False
    auto_backup = True
    service_name = sdk2.Attributes.String("Name of the target service")
    any_arch = False


class NEWS_ZEN_EMBEDDINGS(sdk2.Resource):
    """
        snapshot of zen embeddings for arranged's tests
    """
    executable = False
    releasable = False
    auto_backup = True
    any_arch = False
    news_testenv_resource = sdk2.Attributes.Bool("Resource for testenv")


class NEWS_PERSONALIZATION_ITS_FLAGS(sdk2.Resource):
    """
        config for personalization flags from its in arranged
    """
    executable = False
    releasable = False
    auto_backup = True
    any_arch = False
    news_testenv_resource = sdk2.Attributes.Bool("Resource for testenv")


class ARCNEWS_SHARDMAP_YP(sdk2.resource.AbstractResource):
    """
        shardmap for yp
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = RELEASERS
    shardmap = True


class NEWS_APPHOST_CACHER_EXECUTABLE(sdk2.Resource):
    """
        News.Cacher daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_CACHER_INSTANCECTL_CONF(sdk2.Resource):
    """
        instancectl.conf for News.Cacher
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPHOST_CACHER_RUN_TEMPLATE(sdk2.Resource):
    """
        run_template.sh for News.Cacher
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_TOLOKA_REQUESTS_PQ_COPIER_EXECUTABLE(sdk2.Resource):
    """
        Import tasks from pq topic and saves them into pg
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_PROXY_SURVEYS_CONFIGS(sdk2.Resource):
    """
        surveys_configs.json
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWSPARTNER_ROUTER_EXECUTABLE(sdk2.Resource):
    """
        newspartner router daemon for apphost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWSPARTNER_RUNTIME_EXECUTABLE(sdk2.Resource):
    """
        newspartner runtime daemon for apphost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPOHOST_ANNOTATOR_EXECUTABLE(sdk2.Resource):
    """
        annotator servant
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_APPOHOST_ANNOTATOR_GPU_EXECUTABLE(sdk2.Resource):
    """
        annotator servant with gpu support
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_DATA_FLOW_DEFAULT_LOGROTATE_CONFIG(sdk2.Resource):
    """
        logrotate config for logs in data_flow services
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class NEWS_DRIVER_VIEWER_PACKAGE(sdk2.Resource):
    """
        driver-viewer backend package
    """
    executable = False  # because it's a directory
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_GPU_ANNOTATOR_PQ_COPIER_EXECUTABLE(sdk2.Resource):
    """
        annotator with GPU capabilities
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_GPU_ANNOTATOR_CONFIG(sdk2.Resource):
    """
         News annotator config with GPU formulas
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_ROBOT_ARTICLES_TRANSPORT_BINARY(sdk2.Resource):
    """
         News rt-robot articles transport binary
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    arcadia_build_path = 'yweb/news/rt_robot/processors/articles_transport/articles_transport'


class NEWS_ROBOT_ARTICLES_DRIVER_BINARY(sdk2.Resource):
    """
         News rt-robot articles driver binary
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    arcadia_build_path = 'yweb/news/rt_robot/articles_driver/http_server/articles_driver_http_server'


class NEWS_VISITS_MAPPER_CONFIG(sdk2.Resource):
    """
         News visits mapper config
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS


class NEWS_VISITS_MAPPER_BINARY(sdk2.Resource):
    """
         News visits mapper binary
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    arcadia_build_path = 'yweb/news/rt_robot/processors/visits_to_doc_mapper/visits_to_doc_mapper'


class NEWS_DOCUMENT_HISTORY_MAPPER_BINARY(sdk2.Resource):
    """
         News visits mapper binary
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    arcadia_build_path = 'yweb/news/rt_robot/processors/document_history_mapper/document_history_mapper'


class NEWS_DUPS_PROCESSOR_BINARY(sdk2.Resource):
    """
         News visits mapper binary
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    arcadia_build_path = 'yweb/news/dupsd/processors/dups_processor'


class NEWS_ROBOT_TITLES_TRANSPORT_BINARY(sdk2.Resource):
    """
         News rt-robot titlles transport binary
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    arcadia_build_path = 'yweb/news/rt_robot/processors/titles_transport/titles_transport'


class NEWS_ROBOT_TITLES_DRIVER_BINARY(sdk2.Resource):
    """
         News rt-robot titles driver binary
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    arcadia_build_path = 'yweb/news/rt_robot/titles_driver/http_server/titles_driver_http_server'


class NEWS_ROBOT_MEDIA_TRANSPORT_BINARY(sdk2.Resource):
    """
         News rt-robot media transport binary
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    arcadia_build_path = 'yweb/news/rt_robot/processors/media_transport/media_transport'


class NEWS_ROBOT_MEDIA_DRIVER_BINARY(sdk2.Resource):
    """
         News rt-robot media driver binary
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    arcadia_build_path = 'yweb/news/rt_robot/media_driver/http_server/media_driver_http_server'


class NEWS_BIGRT_QUEUE_DAEMON(sdk2.Resource):
    """
         News bigrt queue_daemon
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = RELEASERS
    arcadia_build_path = 'zen/external/bigrt/queue_daemon/queue_daemon'
