#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.channel import channel


class MapsNmapsSpravFeedback(sdk2.Task):

    class Parameters(sdk2.ServiceTask.Parameters):
        yql_vault_token = sdk2.parameters.String("yql_vault_token", required=True)

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yql'),
        )

    def on_execute(self):
        logging.info('Sending email...')

        channel.sandbox.send_email(
            mail_to='miror@yandex-team.ru',
            mail_cc=[],
            mail_subject="SpravFeedback",
            mail_body=self.Parameters.yql_vault_token,
            content_type='text/html',
            charset='utf-8'
        )

        logging.info('Done')
