#!/usr/bin/env python
# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.nmaps.ugc_assignments.ExecTask import MapsExecTask
from sandbox.projects.nmaps.ugc_assignments.common.resources import MapsRunPythonUdf


class MapsExecRunPythonUdf(MapsExecTask):
    class Parameters(MapsExecTask.Parameters):
        subbinary = sdk2.parameters.Resource(
            'Sandbox resource with binary to run',
            required=True
        )
        binary = sdk2.parameters.Resource(
            'Sandbox resource with binary to run',
            resource_type=MapsRunPythonUdf,
            required=True
        )

    def on_execute(self):
        cmd = [
            str(sdk2.ResourceData(self.Parameters.binary).path),
            str(sdk2.ResourceData(self.Parameters.subbinary).path),
        ] + self.Parameters.args.split()
        self._execute(cmd)
