#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging
import os
import subprocess
from sandbox import sdk2
from sandbox.projects.nmaps.ugc_assignments.common.task_utils import get_vault_data


class MapsExecTask(sdk2.Task):
    class Parameters(sdk2.Parameters):
        args = sdk2.parameters.String(
            'command arguments', default=""
        )
        binary = sdk2.parameters.Resource(
            'Sandbox resource with binary to run',
            required=True
        )
        env_vars = sdk2.parameters.Dict('Environment variables name and value')

    def _execute(self, cmd):
        for key, value in self.Parameters.env_vars.iteritems():
            os.environ[key] = get_vault_data(value)
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('exec_binary')) as pl:
            subprocess.check_call(cmd, stdout=pl.stdout, stderr=pl.stdout)

    def on_execute(self):
        cmd = [str(sdk2.ResourceData(self.Parameters.binary).path)] + self.Parameters.args.split()
        self._execute(cmd)
