import copy
from sandbox.projects.nmaps.ugc_assignments.ExecTask import (
    MapsExecTask,
)
from sandbox.projects.nmaps.ugc_assignments.ExecRunPythonUdf import (
    MapsExecRunPythonUdf,
)


def make_create_ugc_tasks_subtask(task):
    args = (
        "--input-table {} "
        "--task-type {} "
        "--env {} "
        "--n-jobs {}"
    ).format(
        task.Context.ugc_assignments_path,
        task.Parameters.assignment_type,
        task.Parameters.environment,
        task.Parameters.create_tasks_jobs,
    )
    env_vars = copy.copy(task.Context.env_vars)
    env_vars["TVM_SECRET"] = task.Context.tvm_secret

    return MapsExecTask(
        task,
        binary=task.Parameters.create_ugc_account_tasks_binary,
        env_vars=env_vars,
        args=args,
        kill_timeout=10 * 3600,  # 10 hours
        description="Create tasks in ugc account",
        notifications=task.Parameters.notifications,
    ).enqueue()


def make_filter_pushes_subtask(task):
    args=(
        "--input {} "
        "--output {} "
        "--old-pushes {} "
        "--old-pushes-table-name {} "
        "--push-id-field assignment_id "
        "--push-type {} "
        "--end-date {} "
        "--cooldown {}"
    ).format(
        task.Context.assignments_path,
        task.Context.pushes_path,
        task.Parameters.yt_path,
        task.Parameters.pushes,
        task.Context.push_type,
        task.Context.today,
        task.Parameters.cooldown,
    )
    return MapsExecRunPythonUdf(
        task,
        binary=task.Parameters.run_python_udf_executable,
        subbinary=task.Parameters.filter_pushes_udf,
        env_vars=task.Context.env_vars,
        args=args,
        kill_timeout=3 * 3600,  # 3 hours
        description="Filter pushes",
        notifications=task.Parameters.notifications,
    ).enqueue()


def make_pack_pushes_subtask(task):
    args=(
        "--input-tables {} "
        "--data-table {} "
        "--push-type {} "
        "--receiver puid "
        "--target ugc_account "
        "--pack-only"
    ).format(
        task.Context.pushes_path,
        task.Context.sup_pushes_path,
        task.Context.push_type,
    )
    return MapsExecTask(
        task,
        binary=task.Parameters.pack_pushes_binary,
        env_vars=task.Context.env_vars,
        args=args,
        kill_timeout=2 * 3600,  # 2 hours
        description="Pack pushes to sup format",
        notifications=task.Parameters.notifications,
    ).enqueue()


def make_send_pushes_subtask(task):
    args = (
        "--send-only "
        "--data-table {} "
        "--sup-logs-table {} "
        "--logbroker-username {}"
    ).format(
        task.Context.sup_pushes_path,
        task.Context.sup_logs_path,
        task.Parameters.logbroker_username,
    )
    env_vars = copy.copy(task.Context.env_vars)
    env_vars["LOGBROKER_TOKEN"] = task.Parameters.logbroker_vault

    return MapsExecTask(
        task,
        binary=task.Parameters.send_pushes_binary,
        env_vars=env_vars,
        args=args,
        kill_timeout=10 * 3600,  # 10 hours
        description="Send pushes",
        notifications=task.Parameters.notifications,
    ).enqueue()
