#!/usr/bin/env python
# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.common.errors import TaskError
from sandbox.common.types.task import Status
from sandbox.projects.maps.common.latest_resources import find_latest_resource
from sandbox.projects.nmaps.ugc_assignments.common.resources import (
    MapsAbstractBinaryForPushes,
)


def get_vault_data(vault):
    if vault.startswith("sec-"):
        return sdk2.Vault.data(vault)
    tokens = vault.split(":")
    if len(tokens) == 2:
        owner, secret = tokens[0], tokens[1]
        return sdk2.Vault.data(owner, secret)
    # Seems given value is not vault, set it to environment variable
    return vault


def ensure_latest_resources(task):
    """
    !!! CAUTION !!!
    This method can be used in the sever-side methods only!
    """
    for name, value in task.Parameters:
        field_resource_type = getattr(type(task.Parameters), name).resource_type
        if not field_resource_type:
            continue

        resource_object = sdk2.Resource[field_resource_type]
        if value is None and issubclass(resource_object, MapsAbstractBinaryForPushes):
            assert not task.Parameters.__locked__, (
                'Looks like you\'re trying to use _ensure_latest_resources in the client-side method. '
                '`task.Parameters` are locked at this stage.'
            )
            latest_resource = find_latest_resource(resource_object, task.Parameters.environment)
            if latest_resource is None:
                raise ValueError(
                    "Cannot find {} resource released to {}".format(
                        field_resource_type,
                        task.Parameters.environment,
                    )
                )
            setattr(task.Parameters, name, latest_resource)


def wait_tasks(tasks):
    return sdk2.WaitTask(
        tasks,
        Status.Group.FINISH + Status.Group.BREAK,
        wait_all=True
    )


def check_subtasks(task):
    # Check subtasks before doing a next stage
    # After sdk2.WaitTask(), self.on_execute() is called again skipping
    # self.memoize_stage blocks that have already been completed in
    # previous calls. So self.check_subtasks() will be called after
    # every WAIT_TASK.
    # https://wiki.yandex-team.ru/sandbox/cookbook/#execution-stages
    if not all(subtask.status == Status.SUCCESS for subtask in task.find()):
        raise TaskError("Child task failed")
