#!/usr/bin/env python
# -*- coding: utf-8 -*-

from sandbox import sdk2
import datetime
from sandbox.projects.nmaps.ugc_assignments.ExecRunPythonUdf import (
    MapsRunPythonUdf,
)


class UgcPushesParameters(sdk2.Parameters):

    with sdk2.parameters.Group("YT params") as yt_params:
        yt_path = sdk2.parameters.String(
            "Path to store results on yt"
        )
        yt_token = sdk2.parameters.String(
            "yt token in sandbox format: OWNER:NAME "
            "for sandbox vault or sec-...[key] for yav",
            default="MAPS-NMAPS:MAPS_WIKI_YT_TOKEN"
        )
        yql_token = sdk2.parameters.String(
            "yql token in sandbox format: OWNER:NAME "
            "for sandbox vault or sec-...[key] for yav",
            default="MAPS-NMAPS:MAPS_WIKI_YQL_TOKEN"
        )

    with sdk2.parameters.Group("Base binaries") as base_binaries:
        run_python_udf_executable = sdk2.parameters.Resource(
            "Sandbox resource ID of run_python_udf executable",
            resource_type=MapsRunPythonUdf,
            required=False,
        )

        with sdk2.parameters.RadioGroup("Environment") as environment:
            environment.values["testing"] = environment.Value("testing", default=True)
            environment.values["stable"] = environment.Value("stable")


class BuildAssignmentsParameters(UgcPushesParameters):
    with sdk2.parameters.Group("Period params") as period_params:
        use_last_date = sdk2.parameters.Bool(
            "Use last available date to fetch uuids",
            default=True,
        )
        with use_last_date.value[False]:
            end_date = sdk2.parameters.String(
                "End date of period to fetch active users",
                 default=(datetime.date.today() - datetime.timedelta(days=1)).isoformat()
            )
        n_days = sdk2.parameters.Integer(
            "Number of days we want to fetch active users",
            default=14
        )
    with sdk2.parameters.Group("YT tables names") as base_yt_tables_names:
        assignments = sdk2.parameters.String(
            "YT-table name with assignments to prepare pushes",
            default="assignments",
        )
        ugc_assignments = sdk2.parameters.String(
            "YT-table name with assignments to prepare pushes",
            default="ugc_assignments",
        )
