# coding=utf-8

BATCH_SIZE = 1024

INTERDC_TABLE = 'tacct_sflow_dci'
EXTERNAL_TABLE = 'tacct_sflow_ext'

NO_INTERNET = '''
AND ((src_macro != 0 OR src_pmacro != 0) AND (dst_macro != 0 OR dst_pmacro != 0))
'''
SOME_INTERNET = '''
AND ((src_macro != 0 OR src_pmacro != 0) OR (dst_macro != 0 OR dst_pmacro != 0))
'''


GEO_FILTER_RU = '''
AND (src_geoid NOT IN (146037711, 146037718, 146037719, 146054782, 146037727, 146037720)
                        AND dst_geoid NOT IN (146037711, 146037718, 146037719, 146054782, 146037727, 146037720)
                )
'''
GEO_FILTER_FI = 'AND NOT ' + GEO_FILTER_RU[4:]

DIMENSIONS_INTERDC = [
    'src_macro', 'dst_macro', 'src_own', 'dst_own', 'src_dc', 'dst_dc']

QUERY_INTERDC = '''
    select
        src_macro.name as src_macro,
        dst_macro.name as dst_macro,
        src_own.name as src_own,
        dst_own.name as dst_own,
        src_dc,
        dst_dc,
        packets,
        traf
    from
    (
        select
            if(src_pmacro > 0, src_pmacro, src_macro) as src,
            if(dst_pmacro > 0, dst_pmacro, dst_macro) as dst,
            src_dc.name as src_dc,
            dst_dc.name as dst_dc,
            src_owner,
            dst_owner,
            sum(packets) as packets,
            sum(bytes) as traf
        from tacct_sflow_dci
        left join tacct_db.dc_geoid as src_dc on src_geoid = src_dc.id
        left join tacct_db.dc_geoid as dst_dc on dst_geoid = dst_dc.id
        where ts between {ts} and {ts}+3600 and date = toDate({ts}, 'UTC')
                and src_dc != dst_dc
        group by src, dst, src_dc, dst_dc, src_owner, dst_owner
        --limit 100
    )
    left join macro as src_macro on src = src_macro.id
    left join macro as dst_macro on dst = dst_macro.id
    left join owner as src_own on src_owner = src_own.id
    left join owner as dst_own on dst_owner = dst_own.id
'''

DIMENSIONS_EXTERNAL = [
    'src_macro', 'src_own', 'dst_macro', 'dst_own', 'iface']

# List of foreign border routers:
# https://racktables.yandex-team.ru/index.php?andor=and&cfe=%7Bborder+router%7D+and+not+%7B%D0%A0%D0%BE%D1%81%D1%81%D0%B8%D1%8F%7D&page=depot&tab=default

# TODO make it if(src_macro.name = '', dst_macro.name, src_macro.name) as macro
# etc
QUERY_EXTERNAL = '''
    select
        src_macro.name as src_macro,
        src_own.name as src_own,
        dst_macro.name as dst_macro,
        dst_own.name as dst_own,
        -- Makes Statface go 413 Request Entity Too Large
        --CONCAT(agents.name, '@', agent_ifaces.name) AS iface,
        if (agents.name IN ('ams1-b1', 'ash-b1', 'fra1-b1', 'jansson', 'sibelius'),
            'foreign', 'domestic') AS iface,
        sum(packets) as packets,
        sum(traf) as traf
    from
    (
        select
            if(src_pmacro > 0, src_pmacro, src_macro) as src,
            if(dst_pmacro > 0, dst_pmacro, dst_macro) as dst,
            src_owner,
            dst_owner,

            --iface_out,
            agent_id,

            sum(packets) as packets,
            sum(bytes) as traf
        from tacct_sflow_ext

        where ts between {ts} and {ts}+3600 and date = toDate({ts}, 'UTC')
            -- Otherwise traffic on non-peer interfaces is accounted
            AND (
                (tacct_sflow_ext.src_owner > 0 AND tacct_sflow_ext.dst_owner = 0) OR
                (tacct_sflow_ext.src_owner = 0 AND tacct_sflow_ext.dst_owner > 0))
        group by src, src_owner, dst, dst_owner, agent_id
        --limit 100
    )
    left join tacct_db.macro as src_macro on src = src_macro.id
    left join tacct_db.macro as dst_macro on dst = dst_macro.id
    left join tacct_db.owner as src_own on src_owner = src_own.id
    left join tacct_db.owner as dst_own on dst_owner = dst_own.id

    left join tacct_db.agents on agent_id = agents.agent_id
    --left join tacct_db.agent_ifaces on iface_out = agent_ifaces.iface_id
    group by src_macro, src_own, dst_macro, dst_own, iface
'''

QUERY_INTERDC_INTERFACES = '''
    select
        agents.name as agent_name,
        agent_ifaces.name as iface_name
    from tacct_sflow_dci
    left join tacct_db.agents on agent_id = agents.agent_id
    left join tacct_db.agent_ifaces on iface_out = agent_ifaces.iface_id
    -- Surely every active interface will appear within 30 seconds.
    where ts between {ts} and {ts}+30 and date = toDate({ts}, 'UTC')
        --and src_dc != dst_dc
    group by agent_name, iface_name
    --limit 100
'''

QUERY_P95_TEMPLATE = """
SELECT
    quantile(0.95)(bps) as p95,
    macro_name FROM (
SELECT
    time,
    MAX(bytes) * 8 / 300 AS bps,
    macro_name
FROM (
    SELECT
        toStartOfInterval({table}.ts, INTERVAL 5 MINUTE) AS time,
        SUM(bytes) AS bytes,
        src_macr.name AS macro_name
    FROM {table}
    LEFT JOIN tacct_db.macro AS src_macr ON IF(src_pmacro > 0, src_pmacro, src_macro) = src_macr.id
    WHERE
        toDate('{month}', 'utc') <= {table}.date AND {table}.date < toDate('{next_month}', 'utc')
        AND toDateTime('{month}T00:00:00') <= {table}.ts AND {table}.ts < toDateTime('{next_month}T00:00:00')
        {geo_filter}
        {macro_filter}
    GROUP BY time, macro_name

    UNION ALL

    SELECT
        toStartOfInterval({table}.ts, INTERVAL 5 MINUTE) AS time,
        SUM(bytes) AS bytes,
        dst_macr.name AS macro_name
    FROM {table}
    LEFT JOIN tacct_db.macro AS dst_macr ON IF(dst_pmacro > 0, dst_pmacro, dst_macro) = dst_macr.id
    WHERE
        toDate('{month}', 'utc') <= {table}.date AND {table}.date < toDate('{next_month}', 'utc')
        AND toDateTime('{month}T00:00:00') <= {table}.ts AND {table}.ts < toDateTime('{next_month}T00:00:00')
        {geo_filter}
        {macro_filter}
    GROUP BY time, macro_name
)
GROUP BY macro_name, time
)
GROUP BY macro_name ORDER BY p95
"""
