# coding=utf-8
"""
peers-report.php tools
"""

import json
import logging

import requests


logger = logging.getLogger(__name__)


_peers_cache = None

RT_PEERS_REPORT_URL = 'https://racktables.yandex.net/export/peers-report.php?format=json'


def get_peers():
    global _peers_cache
    if _peers_cache is not None:
        return _peers_cache

    logger.debug("Fetching peers report from %s", RT_PEERS_REPORT_URL)
    data = json.loads(requests.get(RT_PEERS_REPORT_URL).content)
    result = {}
    for datum in data:
        result[(datum["if_name"], datum["if_port"])] = datum["name"]
    _peers_cache = result
    return result
