"""
Various API fetchers.  Perekladyvayem JSON here.
"""

try:
    from http.client import HTTPSConnection
    from http.client import urlsplit
except ImportError:
    # Sandbox requires BINARY_TASKs to be Python 2.
    from httplib import HTTPSConnection
    from urllib2 import urlparse
    urlsplit = urlparse.urlsplit
import json


ABC_API_HOST = 'abc-back.yandex-team.ru'
ABC_API_PATH_ALL_SERVICES = '/api/v4/services/?fields=id,slug,state,name,name_en,parent,owner'

# Does not work on noc-export
RT_HOST = 'racktables.yandex-team.ru'
RT_ABC_OBJECTS_PATH = '/export/abc-objects.php'

# 20-30 seconds.  Should not be called often.
BOT_HOST = 'bot.yandex-team.ru'
BOT_SERVER_OWNERSHIP_API_PATH = '/api/view.php?name=view_oops_hardware&format=json'


def fetch_abc_svc(oauth_key):
    conn = HTTPSConnection(ABC_API_HOST)
    res = []
    next_url = ABC_API_PATH_ALL_SERVICES
    while True:
        conn.request('GET', next_url, headers={'Authorization': 'OAuth ' + oauth_key})
        data = conn.getresponse().read()
        parsed = json.loads(data)
        page_results = parsed['results']
        res.extend(page_results)
        if not parsed['next']:
            break
        split_url = urlsplit(parsed['next'])
        next_url = split_url.path + '?' + split_url.query
    return res


def fetch_rt_own():
    conn = HTTPSConnection(RT_HOST)
    conn.request('GET', RT_ABC_OBJECTS_PATH)
    data = conn.getresponse().read()
    return json.loads(data)


def fetch_bot_srv():
    conn = HTTPSConnection(BOT_HOST)
    conn.request('GET', BOT_SERVER_OWNERSHIP_API_PATH)
    data = conn.getresponse().read()
    return json.loads(data)


# TODO
def fetch_walle_prj(oauth_key):
    return {}
