
from collections import defaultdict



def service_children_map(flat_list_of_services):
    res = defaultdict(list)
    for svc in flat_list_of_services:
        if 'parent' in svc and svc['parent']:
            res[svc['parent']['slug'].lower()].append(svc['slug'].lower())
    return res


def slug_to_id(flat_list_of_services):
    res = dict()
    for svc in flat_list_of_services:
        id_, slug = svc['id'], svc['slug'].lower()
        assert id_ not in res
        assert slug not in res
        res[slug] = id_
        res[str(id_)] = slug
    return res


def format_abc_svc(abc_package):
    all_services = abc_package  # Just this for now.
    return dict(
        all_services=all_services,
        service_children_map=service_children_map(all_services),
        slug_to_id=slug_to_id(all_services),
    )


def format_rt_own(rt_package):
    return rt_package


def format_bot_srv(bot_data):
    return bot_data


def format_walle_prj(walle_data):
    return walle_data
