import time
import os

from sandbox import sdk2
from sandbox.sandboxsdk.process import run_process


class RustToolchainsBinary(sdk2.Resource):
    pack_tar = 1  # Pack file or directory to tar (1 - tar, 2 - tgz)
    ttl = float("inf")


class BuildRustToolchains(sdk2.Task):
    def on_execute(self):
        resource = RustToolchainsBinary(self, "rustup, rustc, cargo", "result", creation_ts=int(time.time()))
        res_data = sdk2.ResourceData(resource)
        res_data.path.mkdir(0o755, parents=True, exist_ok=False)

        run_process(["curl", "--version"], log_prefix='check-curl-version')
        rustup_init = "./rustup-init"
        run_process([
            "curl", "-o", rustup_init, "--proto", "=https",
            "-sSf", "https://sh.rustup.rs",
        ], log_prefix='download-rustup-init')
        run_process(["chmod", "+x", rustup_init], log_prefix='run-chmod')

        root_path = str(res_data.path)
        cargo_home = os.path.join(root_path, ".cargo")
        os.environ["CARGO_HOME"] = cargo_home
        rustup_home = os.path.join(root_path, ".rustup")
        os.environ["RUSTUP_HOME"] = rustup_home

        run_process([rustup_init, "-y"], log_prefix='run-rustup-init')
        run_process([os.path.join(cargo_home, "bin/rustup"), "update"], log_prefix='run-rustup-update')
        run_process([os.path.join(cargo_home, "bin/rustup"), "default", "stable"], log_prefix='run-rustup-default')
