# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.sandboxsdk.environments import PipEnvironment


class Lebedev10SandboxTest(sdk2.Task):
    """ Test task to check sandbox capabilities with startrek and yav """

    class Requirements(sdk2.Requirements):
        environments = [PipEnvironment('startrek_client')]

    class Parameters(sdk2.Task.Parameters):
        # common parameters
        kill_timeout = 60

        # custom parameters
        test_input = sdk2.parameters.String("Test input", default='--no-input-provided--', required=True)
        token = sdk2.parameters.String("Startrek token", default='', required=True)



    def on_execute(self):
        logging.info("SandboxTest is here.")

        logging.info("Test input value: {}".format(self.Parameters.test_input))

        logging.info("Trying to get token from YAV...")
        startrek_token = 'no-token'
        try:
            secret = yav.Secret("sec-01evyqqk5tdk79yn9zmttr2neg")
            startrek_token = secret.data()["token"]
            logging.info("Looks like success, token len() = {}".format(len(startrek_token)))
        except Exception as e:
            logging.info("Failed {}".format(str(e)))

        logging.info("Trying to connect to startrek (1)...")
        try:
            import research
            r = research.Research(startrek_token=startrek_token)
            r.run_tests()
        except Exception as e:
            logging.info("Failed {}".format(str(e)))

        logging.info("Trying to connect to startrek (2)...")
        try:
            from sandbox.projects.nocdev.nocdev_ticket_helper.research import Research
            # from research import Research
            r = Research(startrek_token=startrek_token)
            r.run_tests()
        except Exception as e:
            logging.info("Failed {}".format(str(e)))
