# -*- coding: utf-8 -*-

import logging
import sys

import startrek_client
# from startrek_client import Startrek
# from library.python.startrek_python_client import startrek_client


class Research:
    def __init__(self, mode='sandbox', startrek_token='no-token'):
        self.mode = mode
        self.token = startrek_token

    def run_tests(self):
        self.startrek_test()

    def startrek_test(self):
        logging.info("Connecting to startrek...")
        self.base_url = 'https://st-api.yandex-team.ru/v2/myself'
        self.client = startrek_client.Startrek(
            useragent='NOCDEV ticket helper v1 (python3)',
            base_url=self.base_url,
            token=self.token
        )
        issue = self.client.issues['NOCDEV-3539']
        logging.info("Key: {} type: {} createdBy: {} summary: {}".format(
            issue.key, issue.type.key, issue.createdBy.login, issue.summary))

if __name__ == "__main__":
    root = logging.getLogger()
    root.setLevel(logging.DEBUG)

    handler = logging.StreamHandler(sys.stdout)
    handler.setLevel(logging.INFO)
    formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
    handler.setFormatter(formatter)
    root.addHandler(handler)

    with open('tracker_api_token__single_line.txt', 'r') as f:
        my_local_token = f.read()
        my_local_token = my_local_token.strip('\n')

    r = Research(startrek_token=my_local_token)
    r.run_tests()
