# coding=utf-8
import subprocess
from datetime import datetime

from sandbox import sdk2
from sandbox.projects.ofd.common import OfdBackendStandsResource, StandsDumpContainerParameters, get_pg_params, save_password


class OfdBackendStandsCreateDump(sdk2.Task):
    class Parameters(StandsDumpContainerParameters):
        comment = sdk2.parameters.String('Dump comment', required=True, default='dump')

    def on_execute(self):
        db_url = sdk2.Vault.data('bulletwow', 'stands_db_url')
        save_password(db_url)

        resource = OfdBackendStandsResource(
            self,
            self.Parameters.comment,
            'dump_{}'.format(datetime.utcnow().strftime('%d.%m.%Y_%H-%M-%S_utc')),
            ttl=float('inf')
        )
        data = sdk2.ResourceData(resource)
        data.path.mkdir(0o755, parents=True, exist_ok=True)

        subprocess.check_call(['pg_dump', '-O', '-x', '-c', '-w', '-f', str(data.path.joinpath('dump.sql'))] + get_pg_params(db_url))
        data.ready()
