# coding=utf-8
import subprocess

from sandbox import sdk2
from sandbox.projects.ofd.common import OfdBackendStandsResource, StandsDumpContainerParameters, get_pg_params, save_password


class OfdBackendStandsApplyDump(sdk2.Task):
    class Parameters(StandsDumpContainerParameters):
        dump = sdk2.parameters.Resource('Dump', required=True, resource_type=OfdBackendStandsResource)

    def on_execute(self):
        db_url = sdk2.Vault.data('bulletwow', 'stands_db_url')
        save_password(db_url)

        subprocess.check_call(['psql', '-w', '-f', str(sdk2.ResourceData(self.Parameters.dump).path.joinpath('dump.sql'))] + get_pg_params(db_url))
