# coding=utf-8
from urlparse import urlsplit

from pathlib2 import Path
from sandbox.projects.sandbox import resources

from sandbox import sdk2


class VcsParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group("VCS") as vcs_common_block:
        with sdk2.parameters.RadioGroup('VCS') as vcs:
            vcs.values.git = vcs.Value(value='Git', default=False)
            vcs.values.arcadia = vcs.Value(value='Arcadia', default=True)

            with vcs.value['git']:
                git_url = sdk2.parameters.String("Git репозиторий",
                                                 description="Адрес git репозитария",
                                                 required=True)
                git_branch = sdk2.parameters.String("Ветка",
                                                    description="Ветка git репозитария",
                                                    required=True,
                                                    default="master")
            with vcs.value['arcadia']:
                arcadia_url = sdk2.parameters.String("Arcadia URL", required=True, default="arcadia:/arc/trunk/arcadia")
                arcadia_path = sdk2.parameters.String("Путь внутри Аркадии до проекта", required=True, default="ofd/")


class OfdBackendStandsResource(sdk2.Resource):
    pass


class StandsDumpContainerParameters(sdk2.Task.Parameters):
    container = sdk2.parameters.Container(
        'Environment container resource',
        default_value=928456217,
        resource_type=resources.LXC_CONTAINER,
        required=True,
    )


def get_pg_params(db_url):
    db_url = urlsplit(db_url)
    return [
        '-h', db_url.hostname,
        '-p', str(db_url.port),
        '-U', db_url.username,
        '-d', db_url.path[1:]
    ]


def save_password(db_url):
    db_url = urlsplit(db_url)
    text = ':'.join([db_url.hostname, str(db_url.port), db_url.path[1:], db_url.username, db_url.password])
    pgpass = Path.home().joinpath('.pgpass')
    pgpass.touch(mode=0o600, exist_ok=True)
    pgpass.write_text(unicode(text, encoding='utf8'), encoding='utf8')
