from sandbox.sdk2.helpers.misc import MemoizeCreator as BaseMemoizeCreator


class MemoizeCreator(BaseMemoizeCreator):
    def __init__(self, task, stage, retry):
        self.__task = task
        self.__stage = stage
        self.__retry = retry

    def __name(self, name):
        return "{}__{}__{}".format(self.__stage, self.__retry, name)

    def __getattr__(self, name):
        return super(MemoizeCreator, self).__getattr__(self.__name(name))

    def __getitem__(self, name):
        return super(MemoizeCreator, self).__getitem__(self.__name(name))
