# coding=utf-8

from sandbox.projects.metrika.utils.pipeline.contextable import Contextable
from sandbox.projects.ofd.backend.ofd_backend_package_build import OfdBackendPackageBuild
from sandbox.projects.ofd.tasks.ofd_tasks_package_arcadia_build import OfdTasksPackageArcadiaBuild
from sandbox.projects.ofd.notifier.ofd_notifier_package_build import OfdNotifierPackageBuild
from sandbox.projects.ofd.notifier.ofd_notifier_arcadia_package_build import OfdNotifierArcadiaPackageBuild
from sandbox.projects.ofd.ofd_release.service_release_info import ServiceReleaseInfo
from sandbox.projects.ofd.runtime.ofd_runtime_package_build import OfdRuntimePackageBuild
from sandbox.projects.ofd.runtime.ofd_runtime_package_arcadia_build import OfdRuntimePackageArcadiaBuild
from sandbox.projects.ofd.api.ofd_api_package_build import OfdApiPackageBuild
from sandbox.projects.ofd.runbackproxy.ofd_runbackproxy_package_build import OfdRunbackproxyPackageBuild
from sandbox.projects.ofd.metrics_collector.metrics_collector_package_build import OfdMetricsCollectorPackageBuild
from sandbox.projects.ofd.admin.ofd_admin_package_build import OfdAdminPackageBuild


class ReleaseInfo(Contextable):

    @property
    def service_release_info_dict(self):
        return dict((service_release_info.name, service_release_info) for service_release_info in
                    (ServiceReleaseInfo()
                     .with_name("backend")
                     .with_build_name("yandex-ofd-admin-flask")
                     .with_conductor_init_branch("unstable")
                     .with_build_task(OfdBackendPackageBuild.name)
                     .with_release_issue_queue("OFD")
                     .with_release_issue_component(31072)
                     .with_release_issue_followers(["prez"]),

                     ServiceReleaseInfo()
                     .with_name("tasks-arcadia")
                     .with_build_name("ofd-tasks")
                     .with_conductor_init_branch("unstable")
                     .with_build_task(OfdTasksPackageArcadiaBuild.name)
                     .with_release_issue_queue("OFD")
                     .with_release_issue_component(31072)
                     .with_release_issue_followers(["prez"]),

                     ServiceReleaseInfo()
                     .with_name("notifier")
                     .with_build_name("ofd-notifier")
                     .with_conductor_init_branch("unstable")
                     .with_build_task(OfdNotifierPackageBuild.name)
                     .with_release_issue_queue("OFD")
                     .with_release_issue_component(56487)
                     .with_release_issue_followers(["prez"]),

                     ServiceReleaseInfo()
                     .with_name("notifier-arcadia")
                     .with_build_name("ofd-notifier")
                     .with_conductor_init_branch("unstable")
                     .with_build_task(OfdNotifierArcadiaPackageBuild.name)
                     .with_release_issue_queue("OFD")
                     .with_release_issue_component(56487)
                     .with_release_issue_followers(["prez"]),

                     ServiceReleaseInfo()
                     .with_name("ofd_api")
                     .with_build_name("ofd-api")
                     .with_conductor_init_branch("testing")
                     .with_build_task(OfdApiPackageBuild.name)
                     .with_release_issue_queue("OFD")
                     .with_release_issue_component(31072)
                     .with_release_issue_followers(["prez"]),

                     ServiceReleaseInfo()
                     .with_name("ofd_runbackproxy")
                     .with_build_name("ofd-runbackproxy")
                     .with_conductor_init_branch("testing")
                     .with_build_task(OfdRunbackproxyPackageBuild.name)
                     .with_release_issue_queue("OFD")
                     .with_release_issue_component(31072)
                     .with_release_issue_followers(["prez"]),

                     ServiceReleaseInfo()
                     .with_name("ofd_metrics_collector")
                     .with_build_name("ofd-metrics-collector")
                     .with_conductor_init_branch("testing")
                     .with_build_task(OfdMetricsCollectorPackageBuild.name)
                     .with_release_issue_queue("OFD")
                     .with_release_issue_component(31072)
                     .with_release_issue_followers(["prez"]),

                     ServiceReleaseInfo()
                     .with_name("ofd_admin")
                     .with_build_name("ofd-admin")
                     .with_conductor_init_branch("testing")
                     .with_build_task(OfdAdminPackageBuild.name)
                     .with_release_issue_queue("OFD")
                     .with_release_issue_component(31072)
                     .with_release_issue_followers(["prez"]),

                     ServiceReleaseInfo()
                     .with_name("runtime-arcadia")
                     .with_build_name("ofd-runtime")
                     .with_conductor_init_branch("unstable")
                     .with_build_task(OfdRuntimePackageArcadiaBuild.name)
                     .with_release_issue_queue("OFD")
                     .with_release_issue_component(31072)
                     .with_release_issue_followers(["prez"]),

                     ServiceReleaseInfo()
                     .with_name("runtime")
                     .with_build_name("ofd-runtime")
                     .with_conductor_init_branch("unstable")
                     .with_build_task(OfdRuntimePackageBuild.name)
                     .with_release_issue_queue("OFD")
                     .with_release_issue_component(31076)
                     .with_release_issue_followers(["prez"])
                     ))

    @property
    def author(self):
        return self._default_getter()

    @author.setter
    def author(self, value):
        self._default_setter(value)

    def with_author(self, value):
        return self._default_fluent_setter(value)

    @property
    def previous_release_version(self):
        return self._default_getter()

    @previous_release_version.setter
    def previous_release_version(self, value):
        self._default_setter(value)

    def with_previous_release_version(self, value):
        return self._default_fluent_setter(value)

    @property
    def release_version(self):
        return self._default_getter()

    @release_version.setter
    def release_version(self, value):
        self._default_setter(value)

    def with_release_version(self, value):
        return self._default_fluent_setter(value)

    @property
    def release_issue_key(self):
        return self._default_getter()

    @release_issue_key.setter
    def release_issue_key(self, value):
        self._default_setter(value)

    def with_release_issue_key(self, value):
        return self._default_fluent_setter(value)

    @property
    def conductor_ticket(self):
        return self._default_getter()

    @conductor_ticket.setter
    def conductor_ticket(self, value):
        self._default_setter(value)

    def with_conductor_ticket(self, value):
        return self._default_fluent_setter(value)

    @property
    def service_state(self):
        return self._default_getter()

    @service_state.setter
    def service_state(self, value):
        self._default_setter(value)

    def with_service_state(self, value):
        return self._default_fluent_setter(value)

    @property
    def service(self):
        return ServiceReleaseInfo(self.service_state)

    @service.setter
    def service(self, value):
        self.service_state(value.state)

    def with_service(self, value):
        return self.with_service_state(value.state)

    def select_service(self, service):
        self.with_service(self.service_release_info_dict[service])
