import uuid
from datetime import datetime

import dateutil.parser
import dateutil.tz

from sandbox import sdk2


class Datetime(sdk2.parameters.String):
    format = None

    def __new__(cls, *args, **kwargs):
        kwargs.setdefault('default', datetime.utcnow())
        return super(Datetime, cls).__new__(cls, *args, **kwargs)

    @classmethod
    def cast(cls, value):
        return cls.__decode__(value, raise_errors=True)

    @classmethod
    def __encode__(cls, value):
        if isinstance(value, datetime):
            if cls.format:
                return value.strftime(cls.format)
            return value.isoformat()

    @classmethod
    def __decode__(cls, value, raise_errors=False):
        value = super(Datetime, cls).__decode__(value)
        try:
            if isinstance(value, (str, unicode)):
                if cls.format:
                    value = datetime.strptime(value, cls.format)
                else:
                    value = dateutil.parser.parse(value, ignoretz=True)
                return value.replace(tzinfo=dateutil.tz.gettz('UTC'))
            elif isinstance(value, datetime):
                return value
        except (ValueError, TypeError):
            if raise_errors:
                raise


class UUID(sdk2.parameters.String):
    @classmethod
    def cast(cls, value):
        return cls.__decode__(value, raise_errors=True)

    @classmethod
    def __encode__(cls, value):
        if isinstance(value, uuid.UUID):
            return str(value)

    @classmethod
    def __decode__(cls, value, raise_errors=False):
        value = super(UUID, cls).__decode__(value)
        try:
            if isinstance(value, (str, unicode)):
                return uuid.UUID(value)
            elif isinstance(value, uuid.UUID):
                return value
        except (ValueError, TypeError):
            if raise_errors:
                raise
