# -*- coding: utf-8 -*-

from __future__ import print_function, unicode_literals

import logging

from yql.api.v1.client import YqlClient

logger = logging.getLogger(__name__)


ARCADIA_DOGMA_COMMIT_QUERY = """
SELECT
    commit_time,
    author,
    repo_vcs_name,
    repo_vcs_type,
    branch_name,
FROM hahn.`//statbox/qpulse/dogma/raw_commits`
WHERE
    commit_time > DateTime::MakeDatetime(DateTime::StartOfDay(
        CurrentUtcDatetime() - DateTime::IntervalFromDays(3)
    ))
    AND repo_vcs_type="github.yandex-team.ru";
"""

ARCADIA_DOGMA_ALIVE_QUERY = """
SELECT DISTINCT
    repo_vcs_name,
    repo_vcs_type
FROM hahn.`//statbox/qpulse/dogma/raw_commits`
WHERE
    commit_time > DateTime::MakeDatetime(DateTime::StartOfDay(
        CurrentUtcDatetime() - DateTime::IntervalFromDays(180)
    ))
    AND commit_time <= CurrentUtcDatetime()
    AND repo_vcs_type="github.yandex-team.ru";
"""


class YQLManifest(object):
    @staticmethod
    def make_client(token):
        logger.debug("Making YQL client")
        client = YqlClient(token=token)
        return client

    @staticmethod
    def make_request(client, query):
        logger.debug("Making request to YQL")
        request = client.query(query, syntax_version=1)
        request.run()
        return request

    @staticmethod
    def get_results(request):
        logger.debug("Waiting for YQL results")
        for table in request.get_results():
            logger.debug("Got YQL results")
            table.fetch_full_data()
            return table
