# -*- coding: utf-8 -*-

from __future__ import absolute_import, print_function, division

from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.common.types import resource as ctr


class OkoTaskMixin(object):
    class Parameters(sdk2.Task.Parameters):
        use_latest_sandbox_binary = sdk2.parameters.Bool(
            "Always use latest SANDBOX_TASKS_BINARY task resource",
            default=False,
            description="Makes sense for regular runs through Sandbox schedulers",
        )

    def _set_tasks_resource(self):
        if self.Requirements.tasks_resource is not None and not self.Parameters.use_latest_sandbox_binary:
            return

        self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(
            state=ctr.State.READY,
            attrs=dict(
                task_type=self.type.name,
            ),
        ).first()

    def on_create(self):
        self._set_tasks_resource()

    def on_save(self):
        self._set_tasks_resource()

        if self.Requirements.tasks_resource is None:
            raise TaskFailure(
                "Failed to find proper {} resource to run".format(sdk2.service_resources.SandboxTasksBinary.name)
            )
