import logging
import random
import json
import os

from sandbox import sdk2
from sandbox.projects.common import file_utils as fu


class OopsAmmoPost(sdk2.Resource):
     releasable = True
     ammo_type = sdk2.parameters.String()


class GenerateOopsAmmo(sdk2.Task):
    """ Ammo generator for OOPS. """

    class Parameters(sdk2.Task.Parameters):
          hosts_count = sdk2.parameters.Integer(
              'Number of uniq hosts',
              description='test descriptions',
              default=70000,
              required=True
          )

    def make_ammo(self, method, url, headers, case, body):
        """ makes phantom ammo """
        # http request w/o entity body template
        req_template = (
              "%s %s HTTP/1.1\r\n"
              "%s\r\n"
              "\r\n"
        )

        # http request with entity body template
        req_template_w_entity_body = (
              "%s %s HTTP/1.1\r\n"
              "%s\r\n"
              "Content-Length: %d\r\n"
              "\r\n"
              "%s\r\n"
        )

        if not body:
            req = req_template % (method, url, headers)
        else:
            req = req_template_w_entity_body % (method, url, headers, len(body), body)

        # phantom ammo template
        ammo_template = (
            "%d %s\n"
            "%s"
        )

        return ammo_template % (len(req), case, req)

    def gen_fqdn(self):
        fqdn = []
        FQDN_SIZE = 100

        for number in range(FQDN_SIZE):
            fqdn.insert(1, 'ekb1-{}.search.yandex.net'.format(number))

        return fqdn

    def on_execute(self):
        fqdn_json = self.gen_fqdn()
        logging.info('test message')

        oops_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
        logging.info(oops_dir)
        post_json = fu.json_load(os.path.join(oops_dir, 'GenerateOopsAmmo/post.json'))
        logging.info('fqdn url downloaded!')

        resource_data = sdk2.ResourceData(OopsAmmoPost(self, 'POST ammo-file', 'post.ammo', ammo_type='feedback'))

        for number in range(self.Parameters.hosts_count):
            item = []
            item.insert(1, random.choice(fqdn_json))
            method = 'POST'
            case = 'feedback'
            url = '/api/agent/feedback?hostname=' + item[0]
            post_json["hostname"] = item
            body = json.dumps(post_json)

            method, url, case = method.strip(), url.strip(), case.strip()

            headers = "Host: oops-testing.yandex-team.ru\r\n" + \
                "User-Agent: tank\r\n" + \
                "Accept: */*\r\n" + \
                "Content-Type: application/json\r\n" + \
                "Connection: Close"
            fu.append_file(str(resource_data.path.as_posix()), self.make_ammo(method, url, headers, case, body))

        resource_data.ready()

        '''logging.info("Hello, World!")'''
