import logging
import os
import re
import requests

from sandbox import sdk2
from sandbox.projects.common import file_utils as fu
from sandbox.projects.yql.RunYQL2 import RunYQL2
import sandbox.common.types.task as ctt


class OopsAmmoFromYT(sdk2.Resource):
     releasable = True
     ammo_type = sdk2.parameters.String()


class GenerateOopsAmmoFromYT(sdk2.Task):
    """ Ammo generator for OOPS. """

    YQL_API_PROXIED_BASE_URL = "https://yql-api.yandex-team.ru/api/v2"

#    class Parameters(sdk2.Parameters):

 #       with sdk2.parameters.Output:
 #           ammo = sdk2.parameters.Resource('Ammo', required=True)

    def download_link(self, operation_id, token):

        download_url = "{yql_api_base_url}/operations/{operation_id}/results_data?format={format}&write_index=0".format(
            yql_api_base_url=self.YQL_API_PROXIED_BASE_URL,
            operation_id=operation_id,
            format='CSV',
        )

        headers = {
            "User-Agent": "YQL Sandbox (GenerateOopsAmmoFromYT task)",
            "Authorization": "OAuth {token}".format(token=token),
            "Content-Type": "application/json"
        }

        response = requests.get(download_url, headers=headers)

        # remove colum_name
        return re.split(r"\n", response.text, 1)[1]

    def on_execute(self):

        str_query = """
            USE hahn;

            SELECT request
            FROM [home/logfeller/logs/qloud-router-log/1d/%TWO_DAYS_AGO_YEAR%-%TWO_DAYS_AGO_MONTH%-%TWO_DAYS_AGO_DAY%]

            WHERE
                qloud_project = "infra" AND
                qloud_environment = "prod" AND
                qloud_application = "oops" AND
                nginx_request_method = "GET" AND
                datetime LIKE "%T12%" AND
                ( status LIKE "2%" OR status LIKE "3%")
            LIMIT 2000000 ;
        """

        yt_token = sdk2.Vault.data(self.owner, 'LUNAPARK_ROBOT_YT_TOKEN')

        os.environ['YT_TOKEN'] = yt_token
        os.environ['YT_PROXY'] = 'hahn.yt.yandex.net'
        os.environ['YT_LOG_LEVEL'] = 'INFO'

        logging.info('Fetching fresh urls...')
        with self.memoize_stage.create_children:
            sub_task = RunYQL2(
                self,
                description="Fetch fresh urls",
                create_sub_task=False,
                query=str_query,
                yql_token_vault_name='LUNAPARK_ROBOT_YT_TOKEN',
                publish_query=True,
                publish_download_link=True,
                trace_query=True
            ).enqueue()

            self.Context.sub_task = sub_task.id
            self.Context.save()
            raise sdk2.WaitTask(sub_task, ctt.Status.Group.FINISH)

#        operation = self.find(RunYQL2)
        operation_id = self.find(RunYQL2, id=self.Context.sub_task).first()
        self.set_info(operation_id.Parameters.result_operation_id)

        ammo = OopsAmmoFromYT(self, 'Production ammo-file', 'production.ammo', ammo_type='production')
        resource_data = sdk2.ResourceData(ammo)
        fu.append_file(str(resource_data.path.as_posix()), self.download_link(operation_id.Parameters.result_operation_id, yt_token))
        resource_data.ready()
        self.set_info('New ammo resource <a href="{}">{}</a>'.format(ammo.url, ammo.id), do_escape=False)

#        self.Parameters.ammo = ammo
