# -*- coding: utf-8 -*-

import logging
import logging.handlers
import time
import re
import os
from sandbox.projects.common import file_utils as fu

from sandbox import sdk2
#from projects.oops.GenerateOopsAmmo import OopsAmmoPost
#from projects.oops.generate_ammo import KassaGenerateAmmo
from sandbox.projects.tank.ShootViaTankapi import ShootViaTankapi
#from sandbox.projects.tank.LoadTestResults import LoadTestResults
#from sandbox.common import errors
from sandbox.common.types import resource as ctr
from sandbox.common.types import task as ctt

TANKS = [
    'sas1-2129eab868d2.qloud-c.yandex.net:8083'
]

#oops_dir = os.path.dirname(os.path.abspath(__file__))
#tank_configs = os.listdir(oops_dir+'/config')


def logger():
    loggerr = logging.getLogger('%s_%s' % (__name__, time.time()))
    loggerr.setLevel(logging.DEBUG)
    formatter = logging.Formatter('%(asctime)s %(levelname)s [%(processName)s: %(threadName)s] %(message)s')
    file_handler = logging.handlers.RotatingFileHandler(
        'oops_metashooting.log',
        maxBytes=1024 * 1024,
        backupCount=5
    )

    file_handler.setLevel(logging.DEBUG)
    file_handler.setFormatter(formatter)
    loggerr.addHandler(file_handler)
    return loggerr


class OopsMetaShooting(sdk2.Task):
    """ Task for shooting on Oops st/LOAD-650 """

    def start_shooting(self, desc, ammo_source, ammo_resource, config_content):
        subtask_shoot = ShootViaTankapi(
            self,
            description=desc,
            ammo_source=ammo_source,
            ammo_resource=ammo_resource,
            config_source='file',
            config_content=config_content,
            tanks=TANKS
        ).enqueue()
        logger().info('Subtask with shooting is started')
        raise sdk2.WaitTask([subtask_shoot.id], ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True,
                            timeout=14400)

    def on_execute(self):

        oops_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
        logging.info(oops_dir)
        tank_configs = os.listdir(os.path.join(oops_dir, 'OopsMetaShooting/config'))
        logger().info('Oops shooting configs: %s', tank_configs)

        resource_prod_ammo = sdk2.Resource.find(type='OOPS_AMMO_FROM_YT', state=ctr.State.READY).first()
        resource_feedback_ammo = sdk2.Resource.find(type='OOPS_AMMO_POST', state=ctr.State.READY).first()

        for conf_name in tank_configs:
            with self.memoize_stage["shooting_{0}".format(conf_name)]:
                config_content = fu.read_file(os.path.join(oops_dir, 'OopsMetaShooting/config/', conf_name))
                if re.search(r'production log from YT', config_content):
                    self.start_shooting(conf_name, 'resource', resource_prod_ammo, config_content)
                elif re.search(r'feedback', config_content):
                    self.start_shooting(conf_name, 'resource', resource_feedback_ammo, config_content)
                else:
                    self.start_shooting(conf_name, 'in_config', '', config_content)
