#!/usr/bin/python
# -*- coding: utf-8 -*-

import random
import json
import urllib2


def make_ammo(method, url, headers, case, body):
    """ makes phantom ammo """
    # http request w/o entity body template
    req_template = (
          "%s %s HTTP/1.1\r\n"
          "%s\r\n"
          "\r\n"
    )

    # http request with entity body template
    req_template_w_entity_body = (
          "%s %s HTTP/1.1\r\n"
          "%s\r\n"
          "Content-Length: %d\r\n"
          "\r\n"
          "%s\r\n"
    )

    if not body:
        req = req_template % (method, url, headers)
    else:
        req = req_template_w_entity_body % (method, url, headers, len(body), body)

    # phantom ammo template
    ammo_template = (
        "%d %s\n"
        "%s"
    )

    return ammo_template % (len(req), case, req)


def main():

    fqdn_json = json.load(urllib2.urlopen('https://oops.yandex-team.ru/api/hosts/fqdn'))
    post_file = open('post.json')
    post_json = json.load(post_file)

    agent_feedback = open('agent_feedback.ammo', 'w')
    hosts_attributes = open('hosts_attributes.ammo', 'w')
    agent_configs = open('agent_configs.ammo', 'w')
    external_host = open('external_host.ammo', 'w')

######### Write ##############
    for number in range(70000):
        item = []
        item.insert(1, random.choice(fqdn_json))
        method = 'POST'
        case = 'feedback'
        url = '/api/agent/feedback?hostname=' + item[0]
        post_json["hostname"] = item
        body = json.dumps(post_json)

        method, url, case = method.strip(), url.strip(), case.strip()

        headers = "Host: oops-testing.yandex-team.ru\r\n" + \
            "User-Agent: tank\r\n" + \
            "Accept: */*\r\n" + \
            "Content-Type: application/json\r\n" + \
            "Connection: Close"

        agent_feedback.write(make_ammo(method, url, headers, case, body))

        # Write /api/hosts/attributes requests
        method = 'POST'
        case = 'hosts_attributes'
        url = '/api/hosts/attributes'
        body = 'fqdn=' + item[0]

        method, url, case = method.strip(), url.strip(), case.strip()

        headers = "Host: oops-testing.yandex-team.ru\r\n" + \
            "User-Agent: tank\r\n" + \
            "Accept: */*\r\n" + \
            "Content-Type: */*\r\n" + \
            "Connection: Close"

        hosts_attributes.write(make_ammo(method, url, headers, case, body))

        # Write /api/agent/configs requests
        method = 'GET'
        case = 'agent_configs'
        url = '/api/agent/configs/' + item[0]
        body = ''

        method, url, case = method.strip(), url.strip(), case.strip()

        agent_configs.write(make_ammo(method, url, headers, case, body))

        # Write /api/external/host/ request
        method = 'GET'
        case = 'external_host'
        url = '/api/external/host/' + item[0]
        body = ''

        method, url, case = method.strip(), url.strip(), case.strip()

        external_host.write(make_ammo(method, url, headers, case, body))

    agent_feedback.close()
    hosts_attributes.close()
    agent_configs.close()
    external_host.close()


if __name__ == "__main__":
    main()
