from sandbox.projects.ott.backend.common import utils

class ArcanumClient(object):
    ARCANUM_URL = 'https://a.yandex-team.ru/api/'

    def __init__(self, auth=None):
        self._session = utils.createSession()
        self._session.headers['Authorization'] = 'OAuth {}'.format(auth)

    def post_comment(self, review_id, message):
        data = {
            'content': message,
        }
        response = self._session.request('post', self.ARCANUM_URL + 'v1/review-requests/{}/comments'.format(review_id), json=data)
        response.raise_for_status()
