import math

import sandbox.common.types.misc as ctm
from sandbox import sdk2


class OttFaasCleaner(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        ram = 1024
        dns = ctm.DnsType.DNS64

        class Caches(sdk2.Task.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):

        yt_proxy = sdk2.parameters.String('yt-proxy', default_value='hahn')
        yt_secrets = sdk2.parameters.YavSecret('yt-secrets')
        s3_secrets = sdk2.parameters.YavSecret('s3-secrets')
        vh_admin_url = sdk2.parameters.String('vh-admin-url')
        packager_tasks_api_url = sdk2.parameters.String('packager_tasks_api_url')
        yt_table_path = sdk2.parameters.String('yt-table-path')
        yt_table_start_index = sdk2.parameters.Integer('yt-table-start-index')
        yt_buffer_size = sdk2.parameters.Integer('yt-buffer-size', default_value=1000)
        dry_run = sdk2.parameters.Bool('dry-run', default_value=False)
        s3_bucket = sdk2.parameters.String('s3-bucket')
        workers_pool_size = sdk2.parameters.Integer('workers-pool-size')
        cleaner_label = sdk2.parameters.String('cleaner-label')
        max_size = sdk2.parameters.Integer('max-size')
        s3_pool_size_per_worker = sdk2.parameters.Integer('s3-pool-size-per-worker', default_value=5)
        cms_pool_size_per_worker = sdk2.parameters.Integer('cms-pool-size-per-worker', default_value=5)
        telegram_u_duty_project = sdk2.parameters.String('telegram-u-duty-project', default_value='ott-encoder')
        telegram_u_duty_chat_label = sdk2.parameters.String('telegram-u-duty-chat-label',
                                                            default_value='ott-faas-infra')
        inactive_content_version_ttl_days = sdk2.parameters.Integer('inactive-content-version-ttl-days',
                                                                    default_value=31)

    def on_save(self):
        self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(
            attrs={'target': 'sandbox/projects/ott/drm/faas_cleaner'}
        ).first()

        self.Requirements.cores = math.ceil(self.Parameters.workers_pool_size / 5)

    def on_execute(self):
        from ott.drm.faas_infra.cleaner.jobs import OttFaasCleanerJob

        OttFaasCleanerJob(
            yt_proxy=self.Parameters.yt_proxy,
            yt_token=self.Parameters.yt_secrets.data()['YT_TOKEN'],
            vh_admin_url=self.Parameters.vh_admin_url,
            packager_tasks_api_url=self.Parameters.packager_tasks_api_url,
            yt_table_path=self.Parameters.yt_table_path,
            start_index=self.Parameters.yt_table_start_index,
            buffer_size=self.Parameters.yt_buffer_size,
            dry_run=self.Parameters.dry_run,
            s3_bucket=self.Parameters.s3_bucket,
            workers_pool_size=self.Parameters.workers_pool_size,
            cleaner_label=self.Parameters.cleaner_label,
            max_size=self.Parameters.max_size,
            s3_pool_size_per_worker=self.Parameters.s3_pool_size_per_worker,
            cms_pool_size_per_worker=self.Parameters.cms_pool_size_per_worker,
            s3_access_key_id=self.Parameters.s3_secrets.data()['s3-AccessKeyId'],
            s3_secret_access_key=self.Parameters.s3_secrets.data()['s3-AccessSecretKey'],
            sandbox_task_id=sdk2.Task.current.id,
            telegram_u_duty_project=self.Parameters.telegram_u_duty_project,
            telegram_u_duty_chat_label=self.Parameters.telegram_u_duty_chat_label,
            inactive_content_version_ttl_days=self.Parameters.inactive_content_version_ttl_days
        ).run()
