import requests

from ott.drm.library.python.cms.models import InputStreamStatus
from requests.adapters import HTTPAdapter
from urllib3 import Retry


class CallbackClient:
    def __init__(self, timeout: float = 5, max_retries: int = 3):
        self.timeout = timeout
        self._session = requests.Session()
        retries = Retry(total=max_retries, backoff_factor=1, status_forcelist=[500, 502, 503, 504],
                        method_whitelist=['POST'])

        self._session.mount('http://', HTTPAdapter(max_retries=retries))
        self._session.mount('https://', HTTPAdapter(max_retries=retries))

    def send_finished_task_callback(self, url: str, content_group_uuid: str, input_stream_status: InputStreamStatus):
        body = {
            'content_group_uuid': content_group_uuid,
            'status': input_stream_status.value
        }

        self._do_request('POST', url, json=body)

    def _do_request(self, method, url, json=None):
        try:
            response = self._session.request('POST', url, json=json, timeout=self.timeout)
        except requests.exceptions.RequestException as e:
            raise CallbackException(f'Request exception occurs for {method} {url}') from e

        try:
            response.raise_for_status()
        except requests.exceptions.HTTPError as e:
            msg = f'Received 4xx of 5xx response status for {method} {url} ({e.response.text})'
            raise CallbackException(msg) from e


class CallbackException(Exception):
    pass
