from threading import Lock


class SyncedCache:
    """
    Simple cache that guaranteed exactly one key computation.
    Default python cache implementations (functools, cachetools) could compute each key multiple times
     within concurrent requests.
    """

    def __init__(self):
        self._cache = {}
        self._lock = Lock()

    def get(self, key, loader):
        if key in self._cache:
            return self._cache[key]

        with self._lock:
            if key in self._cache:
                return self._cache[key]

            self._cache[key] = loader(key)

            return self._cache[key]
