from typing import List, Optional

from yweb.video.faas.graphs.ott.common import Priority

from ott.drm.library.python.packager_task.clients import PackagerTasksApiClient
from ott.drm.library.python.packager_task.models import TaskStatus, PackagerTask


class QuotaManager:
    def __init__(self, tasks_client: PackagerTasksApiClient, max_not_launched_graphs: int, nirvana_quota: Optional[str],
                 vod_providers: List[str]):
        self.tasks_client = tasks_client
        self.max_not_launched_graphs = max_not_launched_graphs
        self.nirvana_quota = nirvana_quota
        self.vod_providers = vod_providers

    def can_create_graph(self, task: PackagerTask, graph_creating_count: int) -> bool:
        if task.priority == Priority.MAX:
            return True

        created_graphs_count = self.tasks_client.count(
            [TaskStatus.GRAPH_CREATED, TaskStatus.ENQUEUED_FOR_PACKAGE],
            nirvana_quota=self.nirvana_quota,
            vod_providers=self.vod_providers
        )
        return created_graphs_count + graph_creating_count < self.max_not_launched_graphs
