from datetime import datetime, timedelta
from typing import List

from ott.drm.library.python.packager_task.clients import PackagerTasksApiClient
from ott.drm.library.python.packager_task.models import TaskStatus, PackagerTask
from yweb.video.faas.graphs.ott.common import Priority


class QuotaManager:
    def __init__(self, tasks_client: PackagerTasksApiClient, max_running_graphs: int, nirvana_quota: str,
                 vod_providers: List[str], parallel_graph_launch_delay_sec: int):
        self.tasks_client = tasks_client
        self.max_running_graphs = max_running_graphs
        self.nirvana_quota = nirvana_quota
        self.vod_providers = vod_providers
        self.parallel_graph_launch_delay_sec = parallel_graph_launch_delay_sec

    def can_launch_graph(self, task: PackagerTask) -> bool:
        if task.priority == Priority.MAX:
            return True

        packaging_graphs_cnt = self.tasks_client.count(
            [TaskStatus.PACKAGING],
            nirvana_quota=self.nirvana_quota,
            vod_providers=self.vod_providers
        )

        return packaging_graphs_cnt < self.max_running_graphs

    def can_launch_parallel_graph(self) -> bool:
        recent_parallel_graphs_cnt = self.tasks_client.count(
            [TaskStatus.PACKAGING],
            vod_providers=self.vod_providers,
            parallel_encoding=True,
            update_time_lower_bound=datetime.utcnow() - timedelta(seconds=self.parallel_graph_launch_delay_sec)
        )

        return recent_parallel_graphs_cnt == 0
