import uuid

from ott.drm.library.python.cms.models import FaasAnswer, FaasAnswerFormat
from yweb.video.faas.proto.common.outputs_pb2 import TInputVideo


def create_faas_answer(ott_packager_task_id: uuid.UUID, input_video: TInputVideo) -> FaasAnswer:
    return FaasAnswer(
        ott_packager_task_id=ott_packager_task_id,
        width=input_video.Width,
        height=input_video.Height,
        format=FaasAnswerFormat(input_video.Url, input_video.Size)
    )
