import json

from ott.drm.library.python.cms.models import OutputStream
from yweb.video.faas.proto.common.outputs_pb2 import TStream

EDRM_TYPE_TO_CMS_VALUE = {
    TStream.EDrmType.EDT_NONE: None,
    TStream.EDrmType.EDT_WIDEVINE: 'widevine',
    TStream.EDrmType.EDT_FAIRPLAY: 'fairplay',
    TStream.EDrmType.EDT_PLAYREADY: 'playready'
}

ESTREAM_TYPE_TO_CMS_VALUE = {
    TStream.EStreamType.EST_HLS: 'HLS',
    TStream.EStreamType.EST_DASH: 'DASH',
    TStream.EStreamType.EST_MSS: 'MSS',
    TStream.EStreamType.EST_KALTURA: 'KALTURA'
}

EVIDEO_QUALITY_TO_CMS_VALUE = {
    TStream.EVideoQuality.EVQ_SD: 3,
    TStream.EVideoQuality.EVQ_HD: 2,
    TStream.EVideoQuality.EVQ_UHD: 7
}


def create_output_stream(packager_output_stream: TStream) -> OutputStream:
    return OutputStream(
        packager_output_stream.Url,
        EDRM_TYPE_TO_CMS_VALUE[packager_output_stream.DrmType],
        json.loads(packager_output_stream.Meta),
        ESTREAM_TYPE_TO_CMS_VALUE[packager_output_stream.Type],
        EVIDEO_QUALITY_TO_CMS_VALUE[packager_output_stream.VideoQuality],
        playlist_generation=packager_output_stream.PlaylistGeneration or 'from-data'
    )
