import sandbox.common.types.misc as ctm
import sandbox.common.types.task as ctt

from sandbox import sdk2


class OttPackagerBaseTask(sdk2.Task):
    TARGET = 'sandbox/projects/ott/packager_management_system'

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        ram = 1024
        dns = ctm.DnsType.DNS64

        class Caches(sdk2.Task.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):

        packager_tasks_api_url = sdk2.parameters.String('packager_tasks_api_url')
        tasks_resource = None

        with sdk2.parameters.RadioGroup("release") as release:
            release.values[ctt.ReleaseStatus.STABLE] = release.Value(ctt.ReleaseStatus.STABLE, default=True)
            release.values[ctt.ReleaseStatus.TESTING] = release.Value(ctt.ReleaseStatus.TESTING)
            release.values['custom'] = release.Value('custom (resource must be manually explicitly set)')

    def on_save(self):
        if self.Parameters.release != 'custom':
            self.Requirements.tasks_resource = self._get_last_resource_for_selected_and_stable_releases()

    def _get_last_resource_for_selected_and_stable_releases(self):
        tasks_resource = self._find_tasks_resource(self.Parameters.release)

        if self.Parameters.release != ctt.ReleaseStatus.STABLE:
            stable_resource = self._find_tasks_resource(ctt.ReleaseStatus.STABLE)

            if tasks_resource.created < stable_resource.created:
                tasks_resource = stable_resource

        return tasks_resource

    def _find_tasks_resource(self, release):
        return sdk2.service_resources.SandboxTasksBinary.find(
            attrs={'target': self.TARGET, 'released': release}
        ).first()
