from sandbox import sdk2

from sandbox.projects.ott.packager_management_system.sandbox_tasks import OttPackagerBaseTask


class OttPackagerYdbExporter(OttPackagerBaseTask):
    class Parameters(OttPackagerBaseTask.Parameters):
        with sdk2.parameters.Group('Secrets parameters') as secrets_parameters:
            ydb_oauth = sdk2.parameters.YavSecret('Yav secret with YDB oauth token', required=True)
            yt_oauth = sdk2.parameters.YavSecret('Yav secret with YT oauth token', required=True)

        with sdk2.parameters.Group('YDB parameters') as ydb_parameters:
            database = sdk2.parameters.String('YDB database path', required=True)
            ydb_endpoint = sdk2.parameters.String('YDB endpoint', required=True)
            ydb_timeout = sdk2.parameters.Integer('YDB connection timeout', required=True)

        with sdk2.parameters.Group('YT parameters') as yt_parameters:
            yt_dir = sdk2.parameters.String('YT dir for export', required=True)
            yt_proxy = sdk2.parameters.String('YT proxy', required=True)
            yt_port = sdk2.parameters.Integer('YT port', required=True)

        with sdk2.parameters.Group('Export parameters') as export_parameters:
            export_retries = sdk2.parameters.Integer('Export retries', required=True)
            export_timeout = sdk2.parameters.Integer('Export timeout', required=True)

    def on_execute(self):
        from sandbox.projects.ott.packager_management_system.lib.database_exporter import YdbExporter

        # noinspection PyTypeChecker
        YdbExporter(
            database=self.Parameters.database,
            ydb_endpoint=self.Parameters.ydb_endpoint,
            ydb_oauth=self.Parameters.ydb_oauth.data()[self.Parameters.ydb_oauth.default_key],
            ydb_timeout=self.Parameters.ydb_timeout,
            yt_dir=self.Parameters.yt_dir,
            yt_token=self.Parameters.yt_oauth.data()[self.Parameters.yt_oauth.default_key],
            yt_proxy=self.Parameters.yt_proxy,
            yt_port=self.Parameters.yt_port,
            export_retries=self.Parameters.export_retries,
            export_timeout=self.Parameters.export_timeout,
        ).export_to_yt()
