from sandbox import sdk2

from sandbox.projects.ott.packager_management_system.sandbox_tasks import OttPackagerBaseTask


class OttPackagerExporter(OttPackagerBaseTask):
    class Parameters(OttPackagerBaseTask.Parameters):
        vh_admin_url = sdk2.parameters.String('vh_admin_url')
        vh_admin_timeout_sec = sdk2.parameters.Float('vh_admin_timeout_sec')
        max_workers = sdk2.parameters.Integer('max_workers', default_value=4)

    def on_execute(self):
        from sandbox.projects.ott.packager_management_system.lib.exporter import Exporter

        Exporter(
            packager_tasks_api_url=self.Parameters.packager_tasks_api_url,
            vh_admin_url=self.Parameters.vh_admin_url,
            vh_admin_timeout_sec=self.Parameters.vh_admin_timeout_sec,
            sandbox_task_id=sdk2.Task.current.id,
            max_workers=self.Parameters.max_workers
        ).run()
