from sandbox import sdk2

from sandbox.projects.ott.packager_management_system.sandbox_tasks import OttPackagerBaseTask


class OttPackagerImporter(OttPackagerBaseTask):
    class Parameters(OttPackagerBaseTask.Parameters):
        vh_admin_url = sdk2.parameters.String('vh_admin_url')
        vod_provider_ids = sdk2.parameters.List('vod_provider_ids', sdk2.parameters.Integer)
        vh_admin_timeout_sec = sdk2.parameters.Float('vh_admin_timeout_sec')

        default_nirvana_quota = sdk2.parameters.String('default_nirvana_quota')

    def on_execute(self):
        from sandbox.projects.ott.packager_management_system.lib.importer import Importer

        Importer(
            packager_tasks_api_url=self.Parameters.packager_tasks_api_url,
            vh_admin_url=self.Parameters.vh_admin_url,
            vod_provider_ids=self.Parameters.vod_provider_ids,
            vh_admin_timeout_sec=self.Parameters.vh_admin_timeout_sec,
            sandbox_task_id=sdk2.Task.current.id,
            default_nirvana_quota=self.Parameters.default_nirvana_quota
        ).run()
