from sandbox import sdk2

from sandbox.projects.ott.packager_management_system.sandbox_tasks import OttPackagerBaseTask


class OttPackagerLauncher(OttPackagerBaseTask):
    class Parameters(OttPackagerBaseTask.Parameters):
        nirvana_secrets = sdk2.parameters.YavSecret('Yav secret with nirvana oauth token')
        max_running_graphs = sdk2.parameters.Integer('max_running_graphs', default_value=5)

        nirvana_quota = sdk2.parameters.String('nirvana_quota')
        vod_providers = sdk2.parameters.List('vod_providers', value_type=sdk2.parameters.String)
        parallel_graph_launch_delay_sec = sdk2.parameters.Integer('parallel_graph_launch_delay_sec', default_value=60)

    def on_execute(self):
        from sandbox.projects.ott.packager_management_system.lib.launcher import Launcher

        Launcher(
            packager_tasks_api_url=self.Parameters.packager_tasks_api_url,
            nirvana_oauth_token=self.Parameters.nirvana_secrets.data()['token'],
            sandbox_task_id=sdk2.Task.current.id,
            max_running_graphs=self.Parameters.max_running_graphs,
            nirvana_quota=self.Parameters.nirvana_quota,
            vod_providers=self.Parameters.vod_providers,
            parallel_graph_launch_delay_sec=self.Parameters.parallel_graph_launch_delay_sec
        ).run()
