from sandbox import sdk2

from sandbox.projects.ott.packager_management_system.sandbox_tasks import OttPackagerBaseTask


class OttPackagerNotifier(OttPackagerBaseTask):
    class Parameters(OttPackagerBaseTask.Parameters):
        vh_admin_url = sdk2.parameters.String('vh_admin_url')
        vh_admin_timeout_sec = sdk2.parameters.Float('vh_admin_timeout_sec')
        u_duty_project = sdk2.parameters.String('u_duty_project')
        vh_frontend_url = sdk2.parameters.String('vh_frontend_url')
        nirvana_secrets = sdk2.parameters.YavSecret('Yav secret with nirvana oauth token')
        max_workers = sdk2.parameters.Integer('max_workers', default_value=4)

    def on_execute(self):
        from sandbox.projects.ott.packager_management_system.lib.notifier import Notifier

        # comment to trigger deploy
        Notifier(
            packager_tasks_api_url=self.Parameters.packager_tasks_api_url,
            vh_admin_url=self.Parameters.vh_admin_url,
            vh_admin_timeout_sec=self.Parameters.vh_admin_timeout_sec,
            u_duty_project=self.Parameters.u_duty_project,
            vh_frontend_url=self.Parameters.vh_frontend_url,
            nirvana_oauth_token=self.Parameters.nirvana_secrets.data()['token'],
            max_workers=self.Parameters.max_workers
        ).run()
