from sandbox import sdk2

from sandbox.projects.ott.packager_management_system.sandbox_tasks import OttPackagerBaseTask


class OttPackagerPublisher(OttPackagerBaseTask):
    class Parameters(OttPackagerBaseTask.Parameters):
        vh_admin_url = sdk2.parameters.String('vh_admin_url')
        vh_admin_timeout_sec = sdk2.parameters.Float('vh_admin_timeout_sec')
        ott_content_api_url = sdk2.parameters.String('ott_content_api_url')
        ott_content_api_timeout_sec = sdk2.parameters.Float('ott_content_api_timeout_sec')
        max_workers = sdk2.parameters.Integer('max_workers', default_value=4)

    def on_execute(self):
        from sandbox.projects.ott.packager_management_system.lib.publisher import Publisher
        from ott.drm.library.python.cms.clients import VhAdminClient, OttContentApiClient

        Publisher(
            packager_tasks_api_url=self.Parameters.packager_tasks_api_url,
            vh_admin_client=VhAdminClient(self.Parameters.vh_admin_url, self.Parameters.vh_admin_timeout_sec),
            ott_content_api_client=OttContentApiClient(self.Parameters.ott_content_api_url,
                                                       self.Parameters.ott_content_api_timeout_sec),
            max_workers=self.Parameters.max_workers
        ).run()
