from sandbox import sdk2

from sandbox.projects.ott.packager_management_system.sandbox_tasks import OttPackagerBaseTask


class OttPackagerWatcher(OttPackagerBaseTask):
    class Parameters(OttPackagerBaseTask.Parameters):
        nirvana_secrets = sdk2.parameters.YavSecret('Yav secret with nirvana oauth token')

    def on_execute(self):
        from sandbox.projects.ott.packager_management_system.lib.watcher import Watcher

        Watcher(
            packager_tasks_api_url=self.Parameters.packager_tasks_api_url,
            nirvana_oauth_token=self.Parameters.nirvana_secrets.data()['token'],
            sandbox_task_id=sdk2.Task.current.id
        ).run()
