# coding: utf-8

DOCKER_REGISTRY = 'registry.yandex.net'
BACKEND_DOCKER_IMAGE_NAME = 'partners/perl-backend'
FRONTEND_DOCKER_IMAGE_NAME = 'partners/frontend-node'
JAVA_DOCKER_HOURGLASS_IMAGE_NAME = 'partners/java/yandex-partner-java-hourglass'
JAVA_DOCKER_INT_API_IMAGE_NAME = 'partners/java/yandex-partner-java-intapi'
JAVA_DOCKER_JSON_API_IMAGE_NAME = 'partners/java/yandex-partner-java-jsonapi'
JAVA_DOCKER_TEST_API_IMAGE_NAME = 'partners/java/yandex-partner-java-testapi'
AUTOTEST_DB_DOCKER_IMAGE_NAME = 'partners/partner2-db-autotest'
MENTOL_DB_DOCKER_IMAGE_NAME = 'partners/partner2-db-mentol'
GENERAL_DB_DOCKER_IMAGE_NAME = 'partners/partner2-db-general'

ARC_BRANCH_PREFIX = "releases/partner/"

PI_REPO_OWNER = 'partner'
PI_BACKEND_REPO_NAME = 'partner2'
PI_FRONTEND_REPO_NAME = 'yharnam'

KRUSH_URL = 'https://krush.partner.yandex-team.ru/v3'
DEFAULT_CALLBACK_URL = '%s/notifications/release' % KRUSH_URL

DEFAULT_BLACKBOX_URL = 'http://blackbox-mimino.yandex.net'
DEFAULT_YACOTOOLS_URL = 'http://yacotools01et.yandex.ru'
DEFAULT_BK_URL = 'http://bssoap-1.bssoap.pi-integration-qloud.bssoap.yabs-qabs-osc.stable.qloud-d.yandex.net'

# alias used in backend build-and-deploy task
PREPROD_AND_TEST = 'PREPROD_AND_TEST'
TEST_STAGE = 'TEST'
PREPROD_STAGE = 'PREPROD'
# alias
PRODUCTION_STAGE = 'PROD'
# alias for schreenshooter beta stage
SCREENSHOOTER_BETA = 'SCREENSHOOTER_BETA'

FRONTEND_DEFAULT_SOURCE = 'trunk'

PI_BACKEND_LXC_IMAGE = 2256761658
PI_BACKEND_CRON_LXC_IMAGE = 773239891
PI_LXC_WITH_DOCKER = 3126530130
# Не ссылаться в явном виде, вместо этого использовать PartnerFrontLxc
PI_FRONTEND_LXC_IMAGE = 3192257161

STAGE_PREPROD_FIXED_PI = 'partner-preprod-stage'

PARTNER_SSH_VAULT_NAME = 'robot-partner-ssh'
PARTNER_SSH_VAULT_OWNER = 'PARTNER'

BUILD_TYPE_BETA = 'beta'
BUILD_TYPE_RELEASE = 'release'

RELEASE_TYPE_REGULAR = 'release'
RELEASE_TYPE_HOTFIX = 'hotfix'

YAV_TOKEN_VAULT_NAME = 'YAV_TOKEN'
YAV_TOKEN_VAULT_OWNER = 'PARTNER_FRONT'


class AutotestStandType(object):
    def __init__(self):
        pass

    ANY = 'any'
    PARTNER = 'partner'
    ADFOX = 'adfox'


class AutotestBuildType(object):
    def __init__(self):
        pass

    ANY = 'any'
    CI = 'ci'
    RELEASE = 'release'
    LOCAL = 'local'


class AutotestTicketType(object):
    def __init__(self):
        pass

    TESTING = 'testing'
    RELEASE_AUTOTESTS = 'release-autotests'


AUTOTEST_STANDS = [
    {
        'type': AutotestStandType.PARTNER,
        'partner_url': 'https://partner2-autotest.beta.partner.yandex.ru',
        'adfox_url': 'https://partner-1.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.PARTNER,
        'partner_url': 'https://partner2-autotest3.beta.partner.yandex.ru',
        'adfox_url': 'https://partner-2.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-3',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.PARTNER,
        'partner_url': 'https://partner2-autotest4.beta.partner.yandex.ru',
        'adfox_url': 'https://partner-3.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-4',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.PARTNER,
        'partner_url': 'https://partner2-autotest5.beta.partner.yandex.ru',
        'adfox_url': 'https://partner-4.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-5',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.PARTNER,
        'partner_url': 'https://partner2-autotest6.beta.partner.yandex.ru',
        'adfox_url': 'https://partner-5.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-6',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.PARTNER,
        'partner_url': 'https://partner2-autotest7.beta.partner.yandex.ru',
        'adfox_url': 'https://partner-6.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-7',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest2.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-1.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-2',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest8.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-2.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-8',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest9.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-3.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-9',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest10.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-4.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-10',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest11.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-5.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-11',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest16.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-6.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-16',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest17.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-7.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-17',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest18.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-8.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-18',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest19.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-9.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-19',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest20.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-10.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-20',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest21.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-11.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-21',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest22.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-12.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-22',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest23.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-13.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-23',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest24.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-14.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-24',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest25.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-15.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-25',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest26.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-16.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-26',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest27.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-17.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-27',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest28.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-17.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-28',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest29.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-19.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-29',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest30.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-20.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-30',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest31.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-21.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-31',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest32.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-22.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-32',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest33.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-23.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-33',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest34.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-24.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-34',
        'build_type': AutotestBuildType.CI,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest35.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-25.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-35',
        'build_type': AutotestBuildType.CI,
    },
    # release
    {
        'type': AutotestStandType.PARTNER,
        'partner_url': 'https://partner2-autotest12.beta.partner.yandex.ru',
        'adfox_url': 'https://partner-12.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-12',
        'build_type': AutotestBuildType.RELEASE,
    },
    {
        'type': AutotestStandType.PARTNER,
        'partner_url': 'https://partner2-autotest13.beta.partner.yandex.ru',
        'adfox_url': 'https://partner-13.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-13',
        'build_type': AutotestBuildType.RELEASE,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest14.beta.partner.yandex.ru',
        'adfox_url': 'https://adfoxrc-1.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': 'rc',
        'stage_name': 'partner-autotest-stage-14',
        'build_type': AutotestBuildType.RELEASE,
    },
    {
        'type': AutotestStandType.ADFOX,
        'partner_url': 'https://partner2-autotest15.beta.partner.yandex.ru',
        'adfox_url': 'https://adfoxrc-2.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': 'rc',
        'stage_name': 'partner-autotest-stage-15',
        'build_type': AutotestBuildType.RELEASE,
    },
    # local
    {
        'type': AutotestStandType.PARTNER,
        'partner_url': 'https://partner2-autotest36.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-26.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-36',
        'build_type': AutotestBuildType.LOCAL,
    },
    {
        'type': AutotestStandType.PARTNER,
        'partner_url': 'https://partner2-autotest37.beta.partner.yandex.ru',
        'adfox_url': 'https://adfox-27.autotest.yd.adfox.yandex.ru',
        'adfox_stage_id': '0',
        'stage_name': 'partner-autotest-stage-37',
        'build_type': AutotestBuildType.LOCAL,
    },
]

SCREENSHOOTER_REFERENCE_STAND = 'https://screen-ref.beta.partner.yandex.ru'
SCREENSHOOTER_TESTING_STAND = 'https://screen-test.beta.partner.yandex.ru'
SCREENSHOOTER_TESTING_SEMAPHORE = 'partner/autotest/write/partner2-screenshooter-test'

ROBOT_PARTNER_YAV_SECRET = 'sec-01e5srmjek4ct420ztj88r9398'
ROBOT_PARTNER_YAV_SECRET_KEY = 'oauth_token'
ROBOT_PARTNER_SECRET = 'sec-01ctrdr10j7ejcnxak8wb3k5d1'
ROBOT_PARTNER_SECRET_KEY = 'dctl_yp_token'

ROBOT_PEREIRO_STARTREK_TOKEN_SECRET = 'sec-01d8ntjys5pfgtap8f7f57vjy3'
ROBOT_PEREIRO_AWS_SECRET = 'sec-01dzkr7nxzkbcm8pvrf13ns5x4'
ROBOT_PEREIRO_DOCKER_SECRET = 'sec-01e0wr3ferw4jph544mvbqscz0'
ROBOT_PEREIRO_INFRA_TOKEN = 'sec-01eeznq8jawjy264hkew5bwfzt'

AWS_ENDPOINT_URL = 'https://s3.mds.yandex.net'
AWS_PARTNER_BUCKET = 'partners'
ROBOT_BLACK_BEARD_STARTREK_TOKEN_SECRET = 'sec-01e25v12hfzywk4gyg9q4v5wym'

FRONTEND_GITHUB_TOKEN_SECRET = 'sec-01czjs0gyjwyc6zshxzxkq9j8e'
FRONTEND_GITHUB_TOKEN_KEY = 'github-pereiro-token'

OAUTH_VAULT_NAME = "robot-partner-docker-registry-oauth"
OAUTH_VAULT_OWNER = "PARTNER"

PI_STAGES_BY_RELEASE_TYPE = {
    'testing': [
        'partner-test-stage',
    ],
    'prestable': [
        'partner-preprod-stage',
    ],
    'stable': [
        'partner-production-stage',
        'partner-screen-stage-ref',
    ],
    'screenshooter': [
        'partner-screen-stage-test',
    ],
}

PI_RELEASE_TYPES = [
    ('screenshooter', 'screenshooter'),
    (AutotestTicketType.RELEASE_AUTOTESTS, AutotestTicketType.RELEASE_AUTOTESTS)
]

PCODE_API_HOST_PROD = 'pcode-msf-prod.yandex-team.ru'
PCODE_API_HOST_TEST = 'pcode-msf-test.yandex-team.ru'
