# coding: utf-8

ST_USERAGENT = 'Sandbox PARTNER_BUILD_ALL'
ADFOX_CREATE_TICKET_URL = 'https://ui-tools.adfox.yandex-team.ru/release/create-new-release'
ADFOX_LATEST_TAG = 'latest'

ADFOX_DEPLOY_FAILED_MESSAGE = 'Задача выкладки ADFOX на препрод завершилась с ошибкой!\n{task_url}'
PI_DEPLOY_TEST_FAILED_MESSAGE = 'Задача выкладки ПИ на ТС завершилась с ошибкой!\n{task_url}'
PI_DEPLOY_PREPROD_FAILED_MESSAGE = 'Задача выкладки ПИ на препрод завершилась с ошибкой!\n{task_url}'
START_SUCCESS_MESSAGE = 'Запустил сборку релиза\nhttps://sandbox.yandex-team.ru/task/%s'
START_FAILURE_MESSAGE = 'Запуск таски сборки релиза не удался из-за ошибки \nhttps://sandbox.yandex-team.ru/task/%s'

PRODUCTION_SHIP_SUCCESS_MESSAGE = 'Сборка выложена в продакшн.'
PREPROD_DEPLOY_SUCCESS_MESSAGE = 'Сборка выложена в препрод.'

PRODUCTION_SHIP_FAILURE_MESSAGE = 'Ошибка при выкладке сборки в продакшн'
PREPROD_DEPLOY_FAILURE_MESSAGE = 'Ошибка при выкладке сборки в препрод'

BETA_DEPLOY_SUCCESS_MESSAGE = 'Бета развернута.'
BETA_DEPLOY_FAILURE_MESSAGE = 'Ошибка при создании беты'

WAIT_MAX_TIME = 24 * 3600

JAVA_FROM_BRANCH = 'branch'
JAVA_FROM_STRING = 'string'
JAVA_FROM_CUSTOM_TASK = 'custom_task'

ARC_BRANCH_PREFIX = "releases/partner/"

FROM_ORIGINAL_TASK_MSG = 'Inherit from original task'
FROM_ORIGINAL_TASK = 'inherit'

NODE_PI_FRONTEND_BUILD = 'pi_frontend_build'
NODE_PI_PERL_BUILD = 'pi_perl_build'
NODE_PI_JAVA_BUILD = 'node_pi_java_build'
NODE_PI_TEST_DEPLOY = 'pi_test_deploy'
NODE_PI_PREPROD_DEPLOY = 'pi_preprod_deploy'
NODE_ARCADIA_ADD_TICKETS = 'add_arcadia_tickets'
NODE_ADFOX_BUILD = 'adfox_build'
NODE_ADFOX_DEPLOY = 'adfox_deploy'
NODE_PI_SCREENSHOOTER_DEPLOY = 'screenshooter_deploy'
NODE_AUTOTESTS = 'autotests'
NODE_PI_PRODUCTION_SHIP = 'production_ship'
NODE_PI_FRONTEND_FINISH = 'frontend_finish'
NODE_PI_BETA_DEPLOY = 'beta_deploy'
NODE_CREATE_TEST_RUN = 'create_test_run'

# Для конкретных тасок первым в списке должен идти параметр,
# который в частном наследовании должен принимать значение FROM_ORIGINAL_TASK
GROUPS_OF_INHERIT_PARAMETERS = {
    'common': [
        'build_type',
        'st_issue',
        'is_delayed_deploy',
        'is_hotfix',
        'has_regression',
        'should_patch_incomplete_release',
        'incomplete_release_st_issue',
        'do_not_notify_via_infra',
        'deploy_stage_name',
        'skip_not_merged',
    ],
    NODE_PI_PERL_BUILD: [
        'perl_source',
        'perl_branch',
        'perl_tag',
    ],
    NODE_PI_JAVA_BUILD: [
        'java_source_type',
        'java_branch',
        'java_docker_task',
        'java_tag',
        'is_java_task_created',
    ],
    NODE_PI_FRONTEND_BUILD: ['frontend_source', 'frontend_branch', 'yharnam_source', 'frontend_tag'],
    NODE_ADFOX_BUILD: [
        'adfox_branch',
    ],
}

TASKS_DEPENDENCIES = {
    NODE_PI_FRONTEND_BUILD: [],
    NODE_PI_PERL_BUILD: [],
    NODE_PI_JAVA_BUILD: [],
    NODE_ARCADIA_ADD_TICKETS: [NODE_PI_PERL_BUILD, NODE_PI_JAVA_BUILD, NODE_PI_FRONTEND_BUILD],
    NODE_ADFOX_BUILD: [],
    NODE_PI_TEST_DEPLOY: [NODE_PI_PERL_BUILD, NODE_PI_JAVA_BUILD, NODE_PI_FRONTEND_BUILD],
    NODE_PI_PREPROD_DEPLOY: [NODE_PI_PERL_BUILD, NODE_PI_JAVA_BUILD, NODE_PI_FRONTEND_BUILD],
    NODE_PI_PRODUCTION_SHIP: [NODE_PI_PERL_BUILD, NODE_PI_JAVA_BUILD, NODE_PI_FRONTEND_BUILD],
    NODE_PI_FRONTEND_FINISH: [NODE_PI_FRONTEND_BUILD],
    NODE_ADFOX_DEPLOY: [NODE_ADFOX_BUILD],
    NODE_PI_SCREENSHOOTER_DEPLOY: [NODE_PI_PERL_BUILD, NODE_PI_JAVA_BUILD, NODE_PI_FRONTEND_BUILD],
    NODE_AUTOTESTS: [NODE_PI_PERL_BUILD, NODE_PI_JAVA_BUILD, NODE_PI_FRONTEND_BUILD, NODE_ADFOX_BUILD],
    NODE_CREATE_TEST_RUN: [NODE_PI_PREPROD_DEPLOY, NODE_ADFOX_DEPLOY],
}
